/***************************************************************************
 *
 * knetworkmanager-notify.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qgroupbox.h> 
#include <kprogress.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <klocale.h>

#include "knetworkmanager-notify.h"
#include "activation.h"

class DeviceStore;

/* ActivationStageNotifyVPN */

void
ActivationStageNotifyVPN::updateActivationStage ()
{
	State*  state = _ctx->getState ();
	int     progress;
	QString stage;

	/* close dialog if NetworkManager is not running*/
	if (state->isNetworkManagerRunning () == false)
		goto done;

	switch (progress = _vpnConnection->getActivationStage ()) {
		case NM_VPN_ACT_STAGE_PREPARE:
		{
			stage = i18n("Preparing...");
			break;
		}
		case NM_VPN_ACT_STAGE_CONNECT:
		{
			stage = i18n("Connection in progress...");
			break;
		}
		case NM_VPN_ACT_STAGE_IP_CONFIG_GET:
		{
			stage = i18n("Getting IP configuration...");
			break;
		}
		case NM_VPN_ACT_STAGE_ACTIVATED:
		{
			stage = i18n("Successfully connected.");
			break;
		}
		default:
		{
			goto done;
		}
	}

	_activationWidget->pbarActivationStage->setProgress (progress);
	_activationWidget->lblActivationStage->setText (i18n("Activation stage: %1.").arg(stage));

	if (progress == NM_VPN_ACT_STAGE_FAILED || progress == NM_VPN_ACT_STAGE_CANCELED)
		goto done;

	if (progress < NM_VPN_ACT_STAGE_ACTIVATED)
		goto stage_pending;
	
done:
	delete (this);

stage_pending:

	return;
}

ActivationStageNotifyVPN::ActivationStageNotifyVPN (QWidget* parent, const char* name, bool modal, WFlags fl, KNetworkManager* ctx, VPNConnection* vpnConnection)
		: ActivationStageNotify (parent, name, modal, fl, ctx)
{
	QString info;

	if (!vpnConnection)
		return;

	_vpnConnection = vpnConnection;

	QWidget* mainWid = mainWidget ();
	_activationWidget = new ActivationWidget (mainWid, "activationwidget");
	_activationWidget->groupActivation->setTitle (i18n ("Activating VPN Connection"));
	_activationWidget->lblActivation->setText (_vpnConnection->getName ());
	_activationWidget->pbarActivationStage->setTotalSteps (5);
	_activationWidget->lblActivationStage->setText (QString::null);

	connect (parent, SIGNAL (destroyActivationStage ()),
		 this,   SLOT   (destroyActivationStage ()));

	connect (vpnConnection, SIGNAL (activationStateChanged ()),
                 this,          SLOT   (updateActivationStage ()));
	this->show ();
}

ActivationStageNotifyVPN::~ActivationStageNotifyVPN ()
{

}


/* ActivationStageNotifyNetwork */

void
ActivationStageNotifyNetwork::updateActivationStage ()
{
	State*  state = _ctx->getState ();
	int     progress;
	QString stage;

	/* close dialog if NetworkManager is not running*/
	if (state->isNetworkManagerRunning () == false)
		goto done;

	switch (progress = _dev->getActivationStage ()) {
		case NM_ACT_STAGE_DEVICE_PREPARE:
		{
			stage = i18n("Preparing device");
			break;
		}
		case NM_ACT_STAGE_DEVICE_CONFIG:
		{
			stage = i18n("Configuring device");
			break;
		}
		case NM_ACT_STAGE_NEED_USER_KEY:
		{
			stage = i18n("Waiting for passphrase from user");
			break;
		}
		case NM_ACT_STAGE_IP_CONFIG_START:
		{
			stage = i18n("IP configuration started");
			break;
		}
		case NM_ACT_STAGE_IP_CONFIG_GET:
		{
			stage = i18n("IP configuration requested");
			break;
		}
		case NM_ACT_STAGE_IP_CONFIG_COMMIT:
		{
			stage = i18n("Commit IP configuration");
			break;
		}
		case NM_ACT_STAGE_ACTIVATED:
		{
			stage = i18n("Device activated");
			break;
		}
		case NM_ACT_STAGE_FAILED:
		{
			stage = i18n("Device activation failed");
			break;
		}
		case NM_ACT_STAGE_CANCELLED:
		{
			stage = i18n("Device activation canceled");
			break;
		}
		case NM_ACT_STAGE_UNKNOWN:
		default:
		{
			stage = i18n("Unknown");
		}
	}

	_activationWidget->pbarActivationStage->setProgress (progress);
	_activationWidget->lblActivationStage->setText (i18n("Activation stage: %1.").arg(stage));

	if (progress == NM_ACT_STAGE_NEED_USER_KEY)
		goto done;

	if (progress < NM_ACT_STAGE_ACTIVATED)
		goto stage_pending;
	
	if (progress == (int) NM_ACT_STAGE_ACTIVATED) {
//		 TODO should we do something? 
//		printf ("notify::NM_ACT_STAGE_ACTIVATED\n");
	} else if (progress == (int) NM_ACT_STAGE_FAILED) {
//		 TODO some warning 
//		printf ("notify::NM_ACT_STAGE_FAILED\n");
	} else if (progress == (int) NM_ACT_STAGE_CANCELLED) {
//		 TODO some warning 
//		printf ("notify::NM_ACT_STAGE_CANCELLED\n");
	}

done:
	delete (this);

stage_pending:

	return;
}


ActivationStageNotifyNetwork::ActivationStageNotifyNetwork  (const QString & essid, QWidget* parent, const char* name, bool modal, WFlags fl, KNetworkManager* ctx, Device* dev )
		: ActivationStageNotify (parent, name, modal, fl, ctx), _essid( essid )
{
	QString info;

	_dev = dev;

	QWidget* mainWid = mainWidget ();
	_activationWidget = new ActivationWidget (mainWid, "activationwidget");
	if (_dev )
	{
		if ( _essid.isEmpty() ) {
			_activationWidget->groupActivation->setTitle (i18n ("Activating Network Connection"));
			if ((info = _dev->getVendor () + " " + _dev->getProduct ()) == " ")
				info = _dev->getInterface ();
		} else {
			_activationWidget->groupActivation->setTitle (i18n ("Activating Wireless Network Connection"));
			info = _essid;
			info += " (" +  _dev->getInterface () + ")";
		}
	}

	_activationWidget->lblActivation->setText (info);
	_activationWidget->pbarActivationStage->setTotalSteps (7);
	_activationWidget->lblActivationStage->setText (QString::null);

	connect (parent, SIGNAL (destroyActivationStage ()),
		 this,   SLOT   (destroyActivationStage ()));

	connect (_ctx->getDeviceStore (), SIGNAL (deviceStoreChanged (DeviceStore*)),
                 this,                    SLOT   (updateActivationStage ()));

	this->show ();
}

ActivationStageNotifyNetwork::~ActivationStageNotifyNetwork ()
{

}



void
ActivationStageNotify::destroyActivationStage ()
{
	close ();
}

ActivationStageNotify::ActivationStageNotify (QWidget* parent, const char* name, bool modal, WFlags /* fl */, KNetworkManager* ctx)
                               : KDialogBase (parent, name, modal, "Activation", 0 /* KDialogBase::Help|KDialogBase::Ok|KDialogBase::Cancel */, KDialogBase::NoDefault, false)
{
	_ctx = ctx;
	if (!name)
		setName ("ActivationStageNotify");

	setCaption (i18n("Activation"));
	makeVBoxMainWidget ();
	resize (QSize (370, 0));
	clearWState (WState_Polished);
}

ActivationStageNotify::~ActivationStageNotify ()
{

}

#include "knetworkmanager-notify.moc"
