/***************************************************************************
 *
 *   knetworkmanager-state_dbus.cpp - A NetworkManager frontend for KDE
 *   Copyright (C) 2005, 2006 Novell, Inc.
 *
 *   Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful, 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include "knetworkmanager-dbus.h"
#include "knetworkmanager-state_dbus.h"

KNetworkManager* StateDBus::_ctx = NULL;

void
StateDBus::switchWireless (bool set)
{
	DBusConnection* con = _ctx->getDBus ()->getConnection ();
	DBusMessage*    msg = NULL;
	dbus_bool_t     enable = set;

	if (!con) {
		return;
	}

	msg = dbus_message_new_method_call (NM_DBUS_SERVICE, NM_DBUS_PATH, NM_DBUS_INTERFACE, "setWirelessEnabled");
	if (msg) {
		dbus_message_append_args (msg, DBUS_TYPE_BOOLEAN, &enable, DBUS_TYPE_INVALID);
		dbus_connection_send (con, msg, NULL);
		dbus_message_unref (msg);
	}

	return;
}

void
StateDBus::switchMode (const char* method)
{
	DBusConnection* con = _ctx->getDBus ()->getConnection ();
	DBusMessage*    msg = NULL;

	if (!con) {
		return;
	}

	msg = dbus_message_new_method_call (NM_DBUS_SERVICE, NM_DBUS_PATH, NM_DBUS_INTERFACE, method);
	if (msg) {
		dbus_connection_send (con, msg, NULL);
		dbus_message_unref (msg);
	}

	return;
}

void
StateDBus::setWirelessState (bool wireless_state)
{
	State* state = _ctx->getState ();

	state->updateWirelessState (wireless_state);

	return;
}

void
StateDBus::getWirelessStateCallback (DBusPendingCall* pcall, void* /*data*/)
{
	DBusConnection* con   = _ctx->getDBus ()->getConnection ();
	DBusMessage*    reply = NULL;
	bool            state = false;

	if (!con || !pcall) {
		return;
	}

	reply = dbus_pending_call_steal_reply (pcall);
	if (!reply) {
		goto out;
	}

	if (dbus_message_get_args (reply, NULL, DBUS_TYPE_BOOLEAN, &state, DBUS_TYPE_INVALID)) {
		setWirelessState (state);
	}

	dbus_message_unref (reply);

out:
	dbus_pending_call_unref (pcall); 

	return;
}

void
StateDBus::getWirelessState (void)
{
	DBusConnection*  con   = _ctx->getDBus ()->getConnection ();
	DBusMessage*     msg   = NULL;
	DBusPendingCall* pcall = NULL;

	if (!con) {
		return;
	}

	msg = dbus_message_new_method_call (NM_DBUS_SERVICE, NM_DBUS_PATH, NM_DBUS_INTERFACE, "getWirelessEnabled");
	if (msg) {
		dbus_connection_send_with_reply (con, msg, &pcall, -1);
		if (pcall) {
			dbus_pending_call_set_notify (pcall, StateDBus::getWirelessStateCallback, NULL, NULL);
		}
		dbus_message_unref (msg);
	}
}

void
StateDBus::setState (NMState nmstate)
{
	State* state = _ctx->getState ();

	state->setState (nmstate);

	return;
}

void
StateDBus::getStateCallback (DBusPendingCall* pcall, void* /*data*/)
{
	DBusConnection* con     = _ctx->getDBus ()->getConnection ();
	DBusMessage*    reply   = NULL;
	NMState         nmstate = NM_STATE_UNKNOWN;

	if (!con || !pcall) {
		return;
	}

	reply = dbus_pending_call_steal_reply (pcall);
	if (!reply) {
		goto out;
	}

	if (dbus_message_get_args (reply, NULL, DBUS_TYPE_UINT32, &nmstate, DBUS_TYPE_INVALID)) {
		setState (nmstate);
	}

	dbus_message_unref (reply);

out:
	dbus_pending_call_unref (pcall); 

	return;
}

void
StateDBus::getState (void)
{
	DBusConnection*  con = _ctx->getDBus ()->getConnection ();
	DBusMessage*     msg = NULL;
	DBusPendingCall* pcall = NULL;

	if (!con) {
		return;
	}

	msg = dbus_message_new_method_call (NM_DBUS_SERVICE, NM_DBUS_PATH, NM_DBUS_INTERFACE, "state");
	if (msg) {
		dbus_connection_send_with_reply (con, msg, &pcall, -1);
		if (pcall) {
			dbus_pending_call_set_notify (pcall, StateDBus::getStateCallback, NULL, NULL);
		}
		dbus_message_unref (msg);
	}
}

bool
StateDBus::isNetworkManagerRunning ()
{
	DBusConnection* con        = _ctx->getDBus ()->getConnection ();
	bool            nm_running = false;

	if (!con) {
		return nm_running;
	}
	
	nm_running = dbus_bus_name_has_owner (con, NM_DBUS_SERVICE, NULL);

	return nm_running;
}

void
StateDBus::push (KNetworkManager* ctx)
{
	StateDBus::_ctx = ctx;
}

