/***************************************************************************
                          tab_seeklist.h  -  description
                             -------------------
    begin                : Sat Sep 14 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAB_SEEKLIST_H
#define TAB_SEEKLIST_H

#include <kpopupmenu.h>
#include <klistview.h>
#include <qwidget.h>
#include <qstringlist.h>
#include "command.h"

/**
  *@author Troy Corbin Jr.
  */

class resource;

class tab_SeekList : public KListView
{
	Q_OBJECT

	private:
		resource				*myResource;
		KPopupMenu			*menuSeek;
		bool						seek;
		int							selectedMatchID;
		QString					selectedPlayerName;
		/*
				These StringLists temporarily store Sought Game data
				until all ads have been displayed.
		*/
		QStringList			SF_01;
		QStringList			SF_02;
		QStringList			SF_03;
		QStringList			SF_04;
		QStringList			SF_05;
		QStringList			SF_06;
		QStringList			SF_07;

	public:
										tab_SeekList(QWidget *parent=0, const char *name=0, resource *Rsrc=0);
										~tab_SeekList();

	public slots:
		void						recvCMD( const Command& );
		void						display_menuSeek( QListViewItem*, const QPoint&, int );
		void						selectMatch( QListViewItem *Item );
		void						selectMatch( int );
		void						menuFunct( int );

	signals:
		void						sendCMD( const Command& );

	protected:
		void						addSoughtItem( const QString& );
		void						updateSoughtList( void );

};

#endif
