// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.3 $

#include "hk_kdemodulepartwidget.h"
#include "hk_kdemodulepartwidget.moc"
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qclipboard.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <klocale.h>
#include <hk_connection.h>
#include "hk_kdegrid.h"
#include <kparts/genericfactory.h>
//#include "hk_kdegridpart.h"
#include <locale.h>

#include <kmenubar.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kmdichildview.h>
#include <kparts/partmanager.h>
#include "../hk_kdemodulepart/hk_kdemodulepart.h"

class hk_kdemodulepartwidgetprivate
{
public:
        bool          p_autoclose;
        bool 	      p_nodesignmode;
        KParts::ReadWritePart* p_part;
	KParts::ReadWritePart* p_qbepart;
        Kate::View*   p_designkate;
	Kate::Document* p_katepart;
        bool          highlighting_set;
	hk_kdemodulepart* p_modulepart;


};



/*
 *  Constructs a hk_kdemodulepartwidget which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */

hk_kdemodulepartwidget::hk_kdemodulepartwidget(hk_kdemodulepart* part,QWidget* w,const char* n,WFlags f):QWidgetStack(w,n,f),hk_module()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdemodulepartwidget::hk_kdemodulepartwidget");
    hkclassname("hk_kdemodulepartwidget");
#endif
    p_private= new hk_kdemodulepartwidgetprivate;
    p_private->p_modulepart=part;
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    setFocusPolicy(StrongFocus);

 //p_private->p_modulepart->setXMLFile(locate("data","hk_kdeclasses/hk_kdemodulepart.rc"));

    KLibFactory* p_factory= KLibLoader::self()->factory( "libkatepart" );
    p_private->p_katepart = (Kate::Document *) p_factory->create (0L, "kate", "KTextEditor::Document");
    p_private->p_designkate=(Kate::View *)p_private->p_katepart->createView (this, 0L);
    p_private->p_designkate->setFocus();
    setName( "hk_kdemodulepartwidget" );
    resize( 596, 480 );
//    p_design = new QMultiLineEdit(this);
    addWidget(p_private->p_designkate);
    p_private->p_autoclose =true;
    p_saveaction=NULL;
    p_saveasaction=NULL;
    p_printaction=NULL;
    p_copyaction=NULL;
    p_pasteaction=NULL;
    p_replaceaction=NULL;
    p_findaction=NULL;
    p_findnextaction=NULL;
    p_findpreviousaction=NULL;
    p_cutaction=NULL;
    p_undoaction=NULL;
    p_redoaction=NULL;
    p_selectallaction=NULL;
    p_configeditoraction=NULL;

    connect( p_private->p_designkate->getDoc(), SIGNAL( textChanged() ), this, SLOT( module_changed() ) );
    p_private->p_designkate->setLineNumbersOn(true);
    p_private->highlighting_set=false;

    unsigned int i=0;
    Kate::Document *doc = p_private->p_designkate->getDoc();
    if (!p_private->highlighting_set)
    {
        while (i<doc->hlModeCount())
        {
            if (doc->hlModeName(i)=="Python")
            {
                doc->setHlMode(i);
            }
            ++i;
        }
    }

}


hk_kdemodulepartwidget::~hk_kdemodulepartwidget()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdemodulepartwidget::~hk_kdemodulepartwidget");
#endif
    removeWidget(p_private->p_designkate);
    p_private->p_designkate=NULL;
    delete p_private->p_katepart;
    delete p_saveaction;
    delete p_saveasaction;
delete p_private;
#ifdef HK_DEBUG
    hkdebug("hk_kdemodulepartwidget::~hk_kdemodulepartwidget END");
#endif

}








void hk_kdemodulepartwidget::before_source_vanishes(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdemodulepartwidget::before_source_vanishes");
#endif
    if (has_changed())
    {
        save_module();
        reset_has_changed();

    }

    if (p_private->p_autoclose)
        close();
}


void hk_kdemodulepartwidget::module_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdemodule::module_changed");
#endif
    set_has_changed();
    p_saveaction->setEnabled(true);
    set_script(u2l(p_private->p_designkate->getDoc()->text().utf8().data()));

}

bool hk_kdemodulepartwidget::save_module(const hk_string& n,bool ask)
{
  bool result=hk_module::save_module(n,ask);
  
  return result;
}

bool hk_kdemodulepartwidget::load_module(const hk_string& n)
{
set_block_has_changed(true);
  bool result=hk_module::load_module(n);
  cerr <<"load_module script=#"<<script()<<"#"<<endl;
      if (script().c_str())
    {
    p_private->p_designkate->getDoc()->setText(QString::fromUtf8(l2u(script()).c_str()));
    p_private->p_designkate->getDoc()->clearUndo();

    }
    set_caption();
  reset_has_changed();
  set_block_has_changed(false);
  return result;
}

void hk_kdemodulepartwidget::closeEvent ( QCloseEvent* e)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdemodule::closeEvent");
#endif
    if (has_changed())
    {
        save_module();
        reset_has_changed();

    }
    delete p_private->p_katepart;
    p_private->p_katepart=NULL;


    QWidgetStack::closeEvent(e);
   emit signal_closed(this);

}





void hk_kdemodulepartwidget::savebutton_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdemodule::savebutton_clicked");
#endif
    if (save_module("",false))
    {
        reset_has_changed();
        //p_private->p_saveaction->setEnabled(false);
    }
    set_caption();
}


void hk_kdemodulepartwidget::saveasbutton_clicked(void)
{
    if (save_module("",true))
    {
        reset_has_changed();

        set_caption();

    }

}


void hk_kdemodulepartwidget::close_module(void)
{
    close();
}


void hk_kdemodulepartwidget::set_caption(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdemodule::set_caption");
#endif
        QString n=i18n("Module - ");
        n+=QString::fromUtf8(l2u(hk_module::name()).c_str());
        setCaption(n);
    	KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
        if (v) v->setCaption(n);

}


void hk_kdemodulepartwidget::print(void)
{

#ifdef HK_DEBUG
    hkdebug("hk_kdemodule::print");
#endif
// this is a workaround: otherwise float numbers in the postscript file
// would be created with locale dots (e.g. a comma in Germany) from Qt
        hk_string origlocale=setlocale(LC_NUMERIC,NULL);
        hk_string origmonetarylocale=setlocale(LC_MONETARY,NULL);
        setlocale(LC_NUMERIC,"C");
        setlocale(LC_MONETARY,"C");
        p_private->p_designkate->getDoc()->printDialog();
//workaround part 2
        setlocale(LC_NUMERIC,origlocale.c_str());
        setlocale(LC_MONETARY,origmonetarylocale.c_str());
//workaround part 2 end
}


void    hk_kdemodulepartwidget::keyPressEvent ( QKeyEvent * e )
{

  QWidgetStack::keyPressEvent(e);
}




void hk_kdemodulepartwidget::set_autoclose(bool c)
{
p_private->p_autoclose=c;
}


bool hk_kdemodulepartwidget::autoclose(void) const
{
return p_private->p_autoclose;

}



void hk_kdemodulepartwidget::show()
{
  set_block_has_changed(true);
  QWidgetStack::show();
  set_block_has_changed(false);
}

void hk_kdemodulepartwidget::showMaximized()
{
  set_block_has_changed(true);
  QWidgetStack::showMaximized();
  set_block_has_changed(false);

}

void hk_kdemodulepartwidget::set_has_changed(enum_has_changed /*forcesetting*/)
{
//cerr <<"hk_kdemodulepartwidget::set_has_changed"<<endl;
// hk_module::set_has_changed(forcesetting);
 if (p_saveaction)p_saveaction->setEnabled(!runtime_only()&& has_changed());
}



void hk_kdemodulepartwidget::reset_has_changed(void)
{
   hk_module::reset_has_changed();
  if (p_saveaction)p_saveaction->setEnabled(!runtime_only()&& has_changed());
}


void hk_kdemodulepartwidget::copy_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->copy();
}



void hk_kdemodulepartwidget::paste_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->paste();
}

void hk_kdemodulepartwidget::replace_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->replace();
}

void hk_kdemodulepartwidget::find_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->find();
}

void hk_kdemodulepartwidget::findnext_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->findAgain();
}

void hk_kdemodulepartwidget::findprevious_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->findPrev();
}

void hk_kdemodulepartwidget::cut_clicked(void)
{
if (p_private->p_designkate)p_private->p_designkate->cut();
}

void hk_kdemodulepartwidget::undo_clicked(void)
{
if (p_private->p_katepart)p_private->p_katepart->undo();

}

void hk_kdemodulepartwidget::redo_clicked(void)
{
if (p_private->p_katepart)p_private->p_katepart->redo();
}

void hk_kdemodulepartwidget::selectall_clicked(void)
{
if (p_private->p_katepart)p_private->p_katepart->selectAll();
}

void hk_kdemodulepartwidget::configeditor_clicked(void)
{
if (p_private->p_katepart)p_private->p_katepart->configDialog();
}


void hk_kdemodulepartwidget::show_widget(void)
{
  show();
}

void hk_kdemodulepartwidget::hide_widget(void)
{
  hide();
}

bool hk_kdemodulepartwidget::close_widget(void)
{
  return close();
}



bool hk_kdemodulepartwidget::has_changed(void)
{
return hk_module::has_changed();
}

void hk_kdemodulepartwidget::set_block_has_changed(bool)
{

}



