<?php
/******************************
 * Knowledgeroot
 * Frank Habermann
 * 11.04.2006
 *
 * This Class inerhits functions for themes in knowledgeroot
 ******************************/
 
class knowledgeroot_themes {
	var $CLASS;
	var $themes = array();
	var $default_theme = "default";
	var $use_theme = "";
	var $theme_folder = "system/themes/";
	
	// init/start class
	function start(&$CLASS,$theme = "") {
		$this->CLASS =& $CLASS;
		$this->search_themes();
		
		if($theme != "") {
			$this->use_theme = $theme;
		}
	}
	
	function search_themes() {
		if($handle = opendir($this->theme_folder)) {
			while(false !== ($file = readdir($handle))) {
				if($file != "." && $file != "..") {
					$infofile = $this->theme_folder.$file."/info.php";
					if(is_file($infofile)) {
						include($infofile);
						$cssfile = $this->theme_folder.$file."/".$theme['css_file'];
						if(is_file($cssfile)) {
							$this->themes[$theme['name']] = $theme;
						}
					}
				}
			}
		}
	}
	
	// return path to css_file
	function load_theme() {
		if($_SESSION['theme'] != "") {
			$this->use_theme = $_SESSION['theme'];
		}
		
		$default_css_file = $this->theme_folder . $this->default_theme . "/" . $this->themes[$this->default_theme]['css_file'];
		$use_css_file = $this->theme_folder . $this->use_theme . "/" . $this->themes[$this->use_theme]['css_file'];
		
		if(is_file($use_css_file)) {
			$css = $use_css_file;
		} else {
			$css = $default_css_file;
		}
		
		return $css;
	}
	
	// return dropdown with themes
	function theme_dropdown($default = "", $name = "theme") {
		$out = "<select name=\"".$name."\">\n";
		
		foreach($this->themes as $key => $value) {
			$selected = $default == $value['name'] ? "selected" : "";
			$out .= "\t<option value=\"".$value['name']."\" ".$selected.">".$value['name']."</option>\n";
		}
		
		$out .= "</select>\n";
		
		return $out;
	}
	
}
?>