/* @(#) client.c 1.57 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_CLIENT_C "@(#) nitehawk@winghove.1ststep.net|src/client/client.c|20001105061116|31969 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "conf.h"
#include "log.h"
#include "memory.h"
#include "llist.h"
#include "uplinkprotocol.h"
#include "buffer.h"
#include "client.h"
#include "commands.h"
#include "reboot.h"
#include "kparser.h"

/* Initialize state variables */
koalaerror daemoninitstate(void)
{
	char cmdname[100] = "commands";
	commandentry cmd;

	cmd.next = NULL;
	cmd.command = cmdname;
	cmd.handler = do_commandlist;
	cmd.commandtype = CMD_GENERIC;
	cmd.numargs = 0;
	cmd.arglist = NULL;
	cmd.unlock = NULL;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "quit");
	cmd.handler = do_quit;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "reboot");
	cmd.handler = do_reboot;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "shutdown");
	cmd.handler = do_shutdown;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "memstat");
	cmd.handler = do_memstat;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "say");
	cmd.handler = do_say;
	registercommand(&cmd, NULL);
	strcpy(cmdname, "'");
	registercommand(&cmd, NULL);

	strcpy(cmdname, "who");
	cmd.handler = do_who;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "version");
	cmd.handler = do_version;
	registercommand(&cmd, NULL);

	koptions.daemontype = DAEMON_CLIENT;

	return KESUCCESS;
};

/* Startup the daemon */
koalaerror rundaemon(void)
{
	int selectreturn;
	pdescriptor desc = NULL;
	pdescriptor newdesc = NULL;
	koalaerror acceptreturn;
	listnodeptr desclist, tmplist;
	fd_set insockets, outsockets, errsockets;
	int descriptorcount = 0;
	int numuplinks = 0;
	int numplayers = 0;
	int maxdescriptor = 0;
	unsigned long loopcount = 0;
	struct timeval waitcycle;
	char welcome[] = "Welcome to KoalaMud.  This is early development code.\r\n"
			"Please Enter your name:  ";

	/* Startup networking */
	netstartup();

	/* Get master decriptor linked list */
	desclist = getdescriptorlist();
	if (desclist == NULL)
	{
		logmsg(LOGCRIT, "Unable to create descriptor linked list - bail out");
		return KENOMEM;
	}

	/* check to see if this was a reboot */
	if (!(kstate.running == DSTATE_REBOOTING &&
				(reloaddescriptors() == KESUCCESS)))
	{
		/* Attempt to create an uplink */
		if (confcreateuplink(desclist) != KESUCCESS)
		{
			logmsg(LOGWARN, "Error connecting to uplink, use 'link' as an"
					" admin to create an uplink");
		}

		/* Start listening for player connections */
		if (confcreatelisten(desclist) < 0)
		{
			logmsg(LOGCRIT, "Error starting network interface, shutting down");
			return KENONETWORK;
		}
	}

	logmsg(LOGINFO, "Starting main client daemon loop on node ID: %x",
			kstate.nodeid);
	while (kstate.running == DSTATE_RUNNING)
	{
		descriptorcount = 0;
		numuplinks = 0;
		maxdescriptor = 0;
		numplayers = 0;
		FD_ZERO(&insockets);
		FD_ZERO(&outsockets);
		FD_ZERO(&errsockets);

		for(tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;

			// Filter dummy sockets
			if (desc->type == DESCRIPTOR_DUMMY || desc->status > STATUS_NOMINAL)
			{
				continue;
			}
			
			// Add descriptor to select sets
			if (desc->type != DESCRIPTOR_LISTEN)
			{
				if (desc->type == DESCRIPTOR_PLAYER)
				{
					if (!buffer_outbufempty(desc))
					{
						FD_SET(desc->socket, &outsockets);
					}
					numplayers++;
				}
				else
				{
					numuplinks++;
				}
				FD_SET(desc->socket, &errsockets);
			}
			FD_SET(desc->socket, &insockets);
			descriptorcount++;

			maxdescriptor = (maxdescriptor > desc->socket) ?
				maxdescriptor : desc->socket;
		}

		/* Have we reached the reporting period */
		if (((loopcount++) % koptions.reportingperiod) == 0)
		{
			logmsg(LOGINFO,
				"%d descriptors, %d Listen, %d Uplink, %d player, Max FD=%d",
				descriptorcount, (descriptorcount - numuplinks - numplayers),
				(numuplinks), (numplayers), maxdescriptor);
		}
		if (numuplinks == 0 && numplayers == 0)
		{
			logmsg(LOGINFO, "No Connections, sleeping");

			if ((selectreturn = select(maxdescriptor + 1, &insockets,
						NULL, NULL, NULL)) < 0)
			{
				if (errno == EINTR)
				{
					logmsg(LOGINFO, "Waking up to process signal");
				}
				else
				{
					logmsg(LOGERR, "Problems with select - bailing water");
					continue;
				}
			}
			else
			{
				logmsg(LOGINFO, "New connection in progress -"
						" Waking to process");
			}
		}

		/* Setup wait cycle */
		waitcycle.tv_sec = 0;
		waitcycle.tv_usec = koptions.ticklen;
	
		// Block progress until there is data on a socket
		// 	Since this is a hub, we don't need to worry about timing :)
		if ((selectreturn = select(maxdescriptor + 1, &insockets,
			&outsockets, &errsockets, &waitcycle)) < 0)
		{
			if (errno == EINTR)
			{
				logmsg(LOGINFO, "Waking up to process signal");
				continue;
			}
			logmsg(LOGCRIT, "Main client loop dead - falling out");
			return KESELECTFAIL;
		}
		
		/* Loop through descriptors and take appropriate action */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			desc = tmplist->data.desc;

			/* Filter out invalid descriptors */
			if (desc->type == DESCRIPTOR_DUMMY
					|| desc->type == DESCRIPTOR_NULL)
			{
				continue;
			}

			/* First we check for descriptors to close */
			/* Is this descriptor marked for closure */
			if (desc->status == STATUS_CLOSE ||
					FD_ISSET(desc->socket, &errsockets))
			{
				tmplist = listprevnode(tmplist);
				listremovenode(desclist, desc);
				FD_CLR(desc->socket, &insockets);
				FD_CLR(desc->socket, &outsockets);
				kmfree(desc->data.character->name, ALLOC_DESCRIPTOR);
				kmfree(desc->data.character, ALLOC_DESCRIPTOR);
				netclose(desc);
				continue;
			}

			/* Flush a chunk of the output buffer */
			if (FD_ISSET(desc->socket, &outsockets))
			{
				buffer_sendbytes(desc, MAXWRITESIZE);
			}

			/* Handle sockets on the input set */
			if (FD_ISSET(desc->socket, &insockets))
			{
				/* Are we a listener? */
				if (desc->type == DESCRIPTOR_LISTEN)
				{
					acceptreturn = netaccept(desc, &newdesc);
					if (acceptreturn == KENOMEM)
					{
						return KENOMEM;
					}
					if (acceptreturn == KENOACCEPT)
					{
						/* Probaly just no connections waiting
						 * 	shouldn't get this in normal operations */
						logmsg(LOGWARN, "No connections waiting");
						continue;
					}
					newdesc->type = DESCRIPTOR_PLAYER;
					newdesc->status = STATUS_NOMINAL;
					/* Allocate memory for the player information */
					newdesc->data.character = kmalloc(sizeof(character),
							ALLOC_DESCRIPTOR);
					if (newdesc->data.character == NULL)
					{
						logmsg(LOGCRIT, "unable to allocate memory for"
								" character data");
						netclose(newdesc);
						continue;
					}
					bzero(newdesc->data.character, sizeof(character));
					newdesc->data.character->desc = newdesc;
					buffer_queue(newdesc, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
					buffer_queue(newdesc, welcome, strlen(welcome));
					listaddnode(desclist, newdesc);
				} /* if Listener */
				else
				{	 /* Otherwise we just read data into the buffer */
					buffer_receive(desc);
				}
			} // Marked for read?

			/* Parse input and uplink commands */
			if (desc->type == DESCRIPTOR_PLAYER)
			{
				/* Players use the client dispatcher */
				clientdispatcher(desc);
			}
			else if (desc->type == DESCRIPTOR_UNKNOWN &&
						desc->status < STATUS_NOMINAL)
			{
				/* This is an uplink, but we don't know what type yet
				 * - Handle protocol negotiation
				 */
				uplinknegotiatestage(desc);
			}
			/* We can't uplink to a client server */
			else if (desc->type >= DESCRIPTOR_HUBSRV &&
					desc->type <= DESCRIPTOR_ZONESRV &&
					desc->status == STATUS_NOMINAL)
			{
				/* If we have input on an uplink, pass it off to
				 * uplinkreceivemessage
				 */
				uplinkreceivemessage(desc);
			}
		}	// Descriptor Loop
	}	// Main game loop

	if (kstate.running == DSTATE_SHUTDOWN)
	{
		/* If we get here, we were told to shutdown the system, scan through the
		 * descriptor list and send a 'goodbye' message to all players and a
		 * disconnect message to all uplinks */
		for (tmplist = desclist; tmplist; tmplist = listnextnode(tmplist))
		{
			char goodbye[] = "Server is shutting down, come back later\r\n";
			message_data msgdata;
			msgdata.data = NULL;

			desc = tmplist->data.desc;
			
			switch (desc->type)
			{
				case DESCRIPTOR_PLAYER:
					/* Its a player - Send a goodbye message */
					netwrite(desc, goodbye, strlen(goodbye));
					break;

				case DESCRIPTOR_HUBSRV:
				case DESCRIPTOR_CLIENTSRV:
				case DESCRIPTOR_ZONESRV:
					/* Its an uplink - send a disconnect message */
					uplinksendmessage(desc, 0, MSGTYPE_DISCONNECT, &msgdata, 0);
					break;

				default:
					continue;
			}
		}
	}
	return KESUCCESS;
}

/* clientdispatcher - This function calls the appropriate parser for the
 * current player state */
koalaerror clientdispatcher(pdescriptor desc)
{
	/* Make sure we were given 'desc' and that it is a player descriptor */
	if (!desc || desc->type != DESCRIPTOR_PLAYER || !desc->data.character)
	{
		logmsg(LOGWARN, "Caught invalid descriptor in dispatcher");
		return KEMISSINGARG;
	}

	/* We have a valid descriptor, dispatch input to the currect parser */
	switch (desc->data.character->state)
	{
		case STATE_GETNAME:
			return clientgetname(desc);
		case STATE_PLAYING:
			//return clientparsecommand(desc);
			return commandparser(desc);
	}

	return KESUCCESS;
}
