<?php
/*
 * Recurrence tests
 */

ini_set( 'include_path', '../../:../:'.ini_get('include_path'));

include('../misc.php');
include('../recurrence.class.php');
include('../freebusy.class.php');

class TestRecurrence extends Recurrence {
  function setBusy( $start, $end, $duration ) {
    $this->periods[] = array($start,$end,$duration);
  }

  function printperiods() {
    foreach( $this->periods as $p ) {
      if( $p[1] ) {
	print Recurrence::ts2string( $p[0] ).' - '.Recurrence::ts2string( $p[1] )."\n";
      } else {
	print Recurrence::ts2string( $p[0] ).' - '.Recurrence::ts2string( $p[0]+$p[2] )."\n";
      }
    }
  }

  var $periods = array();
};

// Test1: "daynumber in month"
$r =& new TestRecurrence();
$r->setStartDate( FreeBusy::parseDateTime( "2005-03-21T09:00:00Z" ) );
$r->setEndDate( FreeBusy::parseDateTime( "2005-03-21T10:00:00Z" ) );
$r->setCycletype( 'monthly' );
$r->setType( 'daynumber' );
$r->setInterval(1);
$r->setDaynumber(21);

$r->expand( FreeBusy::parseDateTime( "2005-02-01T00:00:00Z" ), 
	    FreeBusy::parseDateTime( "2005-12-01T00:00:00Z" ) );
print "Test1 result:\n";
$r->printperiods();
if( $r->periods != array( /* Results adjusted for CET/CEST switching */
			 array( FreeBusy::parseDateTime( "2005-03-21T09:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-04-21T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-05-21T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-06-21T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-07-21T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-08-21T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-09-21T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-10-21T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-11-21T09:00:00Z" ),
				false, 3600 )
			  ) ) {
  print_r($r->periods);
  print "Test1 failed\n";  
  $tests_failed++;
} else {
  print "Test1 succeeded\n";
  $tests_succeeded++;
}
$tests_total++;

// Test2: "Nth weekday in month"
$r =& new TestRecurrence();
$r->setStartDate( FreeBusy::parseDateTime( "2005-03-21T09:00:00Z" ) );
$r->setEndDate( FreeBusy::parseDateTime( "2005-03-21T10:00:00Z" ) );
$r->setCycletype( 'monthly' );
$r->setType( 'weekday' );
$r->setInterval(1);
$r->setDaynumber(3);
$r->setDay('wednesday');

$r->expand( FreeBusy::parseDateTime( "2005-02-01T00:00:00Z" ), 
	    FreeBusy::parseDateTime( "2005-12-01T00:00:00Z" ) );
print "Test2 result:\n";
$r->printperiods();
if( $r->periods != array( // Results adjusted for CET/CEST switching
			 array( FreeBusy::parseDateTime( "2005-04-20T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-05-18T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-06-15T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-07-20T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-08-17T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-09-21T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-10-19T08:00:00Z" ),
				false, 3600 ),
			 array( FreeBusy::parseDateTime( "2005-11-16T09:00:00Z" ),
				false, 3600 )
			  ) ) {
  print_r($r->periods);
  print "Test2 failed\n";  
  $tests_failed++;
} else {
  print "Test2 succeeded\n";
  $tests_succeeded++;
}
$tests_total++;


// Test3:
?>