/***************************************************************************
                          smbclient.cpp  -  description
                             -------------------
    begin                : Mon Apr 10 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <qregexp.h>


#include <kdebug.h>



#include "smbclient.h"
#include "myktreelistitem.h"

smbclient::smbclient (QObject * parent, MyHostItem * host_item):
QObject (parent)
{
  hostitem = host_item;
  proc = 0;
  out = "";
  err = "";
}


smbclient::~smbclient ()
{
  if (proc)
    {
      kdDebug (7199) << "Process has'nt exited..." << endl;
      proc->kill ();
      delete proc;
    }
}


/** Wird aufgerufen wenn der Process sich beendet */
void
smbclient::onProcExit (KProcess * killedproc)
{
  QString buf, share, typ, comment, newhost, master, workgroup;
  QString os, server;
  int lineidx = 0, index1, index2, index3;
  ulong ip = 0;
  MyShareItem::ShareTypes sharetyp;
  bool exitstatus = false;
  if (killedproc == proc)
    {
      exitstatus = proc->normalExit ();
      delete proc;
      proc = 0;
    }
  else
    kdError (7199) << "Mmmhhh... not my process" << endl;
  // Auswertung
  if (exitstatus == true)
    {				// Smbclient exit normaly ?
      // Look for Hosts (the Workgroup must exist in tree before I looking
      while ((lineidx != -1)
	     && !((buf.contains ("Server")) && (buf.contains ("Comment"))))
	{			//alle zeilen bis incl. "----" auslesen
	  if (buf.contains ("Got a positive name query response from"))
	    {
	      buf =
		buf.mid (buf.find ("(") + 1,
			 buf.find (")") - buf.find ("(") - 1);
	      ip = htonl (inet_addr ((const char *) buf.stripWhiteSpace ()));
	      hostitem->setNetIP (ip);
	    }
	  if (buf.contains ("Server=["))
	    {
	      index1 = buf.find ("Server=[") + 8;
	      server = buf.mid (index1, buf.find ("]", index1) - index1);
	      hostitem->setServer (server);
	    }
	  if (buf.contains ("OS=["))
	    {
	      index1 = buf.find ("OS=[") + 4;
	      os = buf.mid (index1, buf.find ("]", index1) - index1);
	      hostitem->setOS (os);
	    }
	  buf = nextline (out, lineidx);
	}

      index1 = (buf.find ("Server"));
      index2 = (buf.find ("Comment"));
      while ((lineidx != -1) && (buf.contains ("----") == 0))	//alle zeilen bis incl. "----" auslesen
	buf = nextline (out, lineidx);
      buf = nextline (out, lineidx);
      do
	{
	  comment = newhost = buf;
	  newhost = newhost.mid (index1, index2 - index1);
	  newhost = newhost.stripWhiteSpace ();
	  if (newhost.length () > 0)
	    {
	      comment = comment.right (comment.length () - index2);
	      comment = comment.stripWhiteSpace ();
	      if (newhost == hostitem->Name ())
		{
		  emit newHost (newhost, hostitem->getWorkgroupName (),
				comment, ip, os, server);
		}
	      else
		{
		  emit newHost (newhost, hostitem->getWorkgroupName (),
				comment, 0, QString::null, QString::null);
		}
	    }
	  buf = nextline (out, lineidx);
	}
      while ((lineidx != -1) && !((buf.contains ("Workgroup")) && (buf.contains ("Master"))));	//alle zeilen bis incl. "----" auslesen*/
      // Look for Workgroups and Masters
      index1 = (buf.find ("Workgroup"));
      index2 = (buf.find ("Master"));

      while ((lineidx != -1) && (buf.contains ("----") == 0))	//alle zeilen bis incl. "----" auslesen
	buf = nextline (out, lineidx);
      buf = nextline (out, lineidx);
      if (lineidx > 0)
	{
	  do
	    {
	      master = workgroup = buf;
	      workgroup = workgroup.mid (index1, index2 - index1);
	      while ((workgroup.right (1) == " ")
		     && (workgroup.length () > 0))
		workgroup.remove ((uint) workgroup.length () - 1, 1);
	      if (workgroup.length () > 0)
		{
		  master = master.right (master.length () - index2);
		  master = master.stripWhiteSpace ();
		  if (hostitem->Name () == QString ("NONAMEFOUND"))
		    if (workgroup == hostitem->getWorkgroupName ())
		      hostitem->setName (master);
		  if (master == hostitem->Name ())
		    {
		      emit newWorkgroup (workgroup, master, true);
		    }
		  else
		    {
		      emit newWorkgroup (workgroup, master, false);
		    }
		}
	      buf = nextline (out, lineidx);
	    }
	  while ((lineidx != -1));	//alle zeilen bis incl. "----" auslesen*/
	}

      // Look for Shares, must after Look for workgroups and host
      lineidx = 0;
      buf = nextline (out, lineidx);
      while ((lineidx != -1)
	     && ((buf.contains ("Sharename") == 0)
		 || (buf.contains ("Type") == 0)))
	{			//alle zeilen bis incl. "Server" auslesen
	  buf = nextline (out, lineidx);
	}
      index1 = buf.find ("Sharename");
      index2 = buf.find ("Type");
      index3 = buf.find ("Comment");
      while ((lineidx != -1) && (buf.contains ("----") == 0))	//alle zeilen bis incl. "----" auslesen
	buf = nextline (out, lineidx);
      buf = nextline (out, lineidx);
      do
	{
	  comment = typ = share = buf;
	  share.truncate (index2);
	  share.replace (QRegExp ("\t"), "");
	  share.replace (QRegExp ("\n"), "");
	  while ((share.right (1) == " ") && (share.length () > 0))
	    share.remove ((uint) share.length () - 1, 1);
	  if (share.length () > 0)
	    {
	      comment = comment.right (comment.length () - index3);
	      comment.replace (QRegExp ("\t"), "");
	      comment.replace (QRegExp ("\n"), "");
	      comment = comment.stripWhiteSpace ();

	      typ = typ.mid (index2, index3 - index2);
	      typ = typ.upper ();
	      sharetyp = MyShareItem::unknown;
	      if (typ.contains ("PRINTER"))
		sharetyp = MyShareItem::Printer;
	      if (typ.contains ("IPC"))
		sharetyp = MyShareItem::IPC;
	      if (typ.contains ("DISK"))
		sharetyp = MyShareItem::Disk;

	      emit newShare (hostitem->Name (), hostitem->getWorkgroupName (),
			     share, comment, sharetyp);
	    }
	  buf = nextline (out, lineidx);
	}
      while ((lineidx != -1) && !((buf.contains ("Server")) && (buf.contains ("Comment"))));	//alle zeilen bis incl. "----" auslesen
      emit isExited (this, true, out, hostitem);
      emit isExited (this, out, hostitem);
    }
  else
    {
      kdError (7199) << "Error on exiting smbclient : host ='" << hostitem->
	Name () << "'\tworkgroup ='" << hostitem->
	getWorkgroupName () << "'" << endl;
      emit isExited (this, out, hostitem);
    }

}


/** startet den Process (smbclient -L ...)  */
void
smbclient::start ()
{
  QString qip, service;
  proc = new KProcess ();
  if (!proc)
    {
      kdWarning (7199) << "Could not create a process." << endl;
      return;
    }
  (*proc) << "smbclient";
  if (!hostitem->getPassword ().isEmpty ())
    {
      service = "\\\\";
      service += hostitem->Name ();
      service += "\\";
      (*proc) << service << hostitem->getPassword ();
    }
  (*proc) << "-L" << hostitem->Name ();
  (*proc) << "-N";
  (*proc) << "-d" << "2";
  if (!hostitem->getWorkgroupName ().isEmpty ())
    {
      (*proc) << "-W" << hostitem->getWorkgroupName ();
    }
  if (hostitem->getNetIP () != 0)
    {
      hostitem->getIP (&qip);
      (*proc) << "-I" << qip;
    }
  if (!hostitem->getUsername ().isEmpty ())
    (*proc) << "-U" << hostitem->getUsername ();
  connect (proc, SIGNAL (processExited (KProcess *)), this,
	   SLOT (onProcExit (KProcess *)));
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (smbclientStdout (KProcess *, char *, int)));
  connect (proc, SIGNAL (receivedStderr (KProcess *, char *, int)), this,
	   SLOT (smbclientStderr (KProcess *, char *, int)));
  proc->start (KProcess::NotifyOnExit, KProcess::All);
  return;
}


/* Liest buffer in out, wird dann   													*/
/* komplett ausgewertet bei onProcExit()												*/
void
smbclient::smbclientStdout (KProcess *, char *buffer, int n)
{
  out.append (QString::fromLocal8Bit (buffer, n));
}

/* Ausgaben werden Abgefangen */
void
smbclient::smbclientStderr (KProcess *, char *buffer, int n)
{
  QString b (QString::fromLocal8Bit (buffer, n));
  char buf[33];
  if (b.contains ("Password:"))
    {
      strcpy (buf, hostitem->getPassword ());
      strcat (buf, "\n");
      proc->writeStdin (buf, strlen (buf));
      kdError (7199) << "password written" << endl;
    }
  else
    err += b;
}


/** Gibt Zeile ab index bis Ende der Zeile ('\n')
zurck, index ist danach auf Anfang der nchsten Zeile; */
QString smbclient::nextline (QString & in, int &index)
{
  int
    i;
  if (index != -1)
    {
      i = index;
      index = in.find ("\n", index);
      if (index != -1)
	{
	  index++;
	  return in.mid (i, index - i - 1);
	}
      else
	{
	  return in.right (i);
	}
    }
  return "";
}
