/***************************************************************************
                          komba2doc.cpp  -  description
                             -------------------
    begin                : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qwidget.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qmessagebox.h>

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <kprocess.h>
#include <kfiledialog.h>

// application specific includes
#include "komba2doc.h"
#include "komba2.h"
#include "komba2view.h"
#include "password.h"
#include "sendmessage.h"
#include "message.h"
#include "ping.h"
#include "myktreelistitem.h"
#include "smbconfig.h"
#include "mymaster.h"
#include "scan.h"
#include "iplook.h"
#include "mount.h"
#include "unmount.h"
#include "options.h"
#include "socketserver.h"
#include "recentmounts.h"


QList < Komba2View > *Komba2Doc::pViewList = 0L;


Komba2Doc::Komba2Doc (QWidget * parent, const char *name, int option):
QObject (parent, name)
{
  doc_net = 0L;
  iplworkingcount = 0;
  unmountcount = 0;
  mountcount = 0;
  socketservercount = 0;
  allunmounted = false;
  opt = new Options ((QObject *) this, "options");
  ipltodolist = new QStack < MyHostItem >;
  comOpt = option;
  if (comOpt != optNothing)
    opt->setNoPasswordDialog (true);
  modified = false;
  smbconf = new smbConfig ();
  mymaster = new MyMaster (smbconf->getMyWorkgroup (), this);
  connect (mymaster,
	   SIGNAL (isMasterName (const QString &, const QString &, ulong)),
	   this,
	   SLOT (mymasterFound (const QString &, const QString &, ulong)));
  connect (mymaster, SIGNAL (isExited (MyMaster *)), this,
	   SLOT (mymasterIsExited (MyMaster *)));
  scanhost = new scan (this);
  connect (scanhost, SIGNAL (allSmbClientExited ()),
	   this, SLOT (slotNoProcess ()));

  if (!pViewList)
    {
      pViewList = new QList < Komba2View > ();
    }
  pViewList->setAutoDelete (true);
}

Komba2Doc::~Komba2Doc ()
{
}

void
Komba2Doc::addView (Komba2View * view)
{
  // insert MyNetworkItem as TopLevelItem
  if (!doc_net)
    {
      doc_net =
	new MyNetworkItem (this, view->nettree (),
			   QString (i18n ("Network")));
      mymaster->getMaster ();
      scannet ();
    }
  else
    view->nettree ()->insertItem (doc_net);
  connect (this, SIGNAL (noActiveProcess ()), view,
	   SLOT (slotNoActiveProcess ()));

  pViewList->append (view);
}

void
Komba2Doc::removeView (Komba2View * view)
{
  disconnect (this, SIGNAL (noActiveProcess ()), view,
	      SLOT (slotNoActiveProcess ()));
  pViewList->remove (view);

}


void
Komba2Doc::slotUpdateAllViews (Komba2View * sender)
{
  Komba2View *w;
  if (pViewList)
    {
      for (w = pViewList->first (); w != 0; w = pViewList->next ())
	{
	  if (w != sender)
	    w->repaint ();
	}
    }

}

bool Komba2Doc::saveModified ()
{
  bool
    completed =
    true;
  if (!isCommandOptToUnmount () && !isCommandOptToMount ())
    opt->saveAll ();
  return completed;
}

void
Komba2Doc::closeDocument ()
{
//  deleteContents();
}

bool Komba2Doc::newDocument ()
{

  return true;
}

/** add a new host if not allready in networktree */
void
Komba2Doc::InsertHost (const QString & hostname, const QString & workgroup,
		       const QString & comment, u_long ip, const QString & os,
		       const QString & server)
{
  MyHostItem *host =
    getNetwork ()->insertHost (workgroup, hostname, ip, comment, os, server);
  if (options ()->scanAllHosts ())
    scanHost (host);
}

void
Komba2Doc::InsertHost (char *hostname, char *workgroup, u_long ip,
		       bool ismaster)
{
  MyHostItem *host = getNetwork ()->insertHost (workgroup, hostname, ip);
  if (ismaster)
    if (host)
      {
	((MyWorkgroupItem *) host->parent ())->setMaster (host);
      }
  if (options ()->scanAllHosts ())
    scanHost (host);
}

/** Fgt eine neue Workgroup ein (sofern nicht schon vorhanden) */
void
Komba2Doc::InsertWorkgroup (const QString & workgroup, const QString & master,
			    bool)
{
  MyHostItem *masteritem;
  MyWorkgroupItem *wg = getNetwork ()->insertWorkgroup (workgroup);
  if (master.length () > 0)
    {
      masteritem = getNetwork ()->getHost (workgroup, master);
      if (!masteritem)
	masteritem = getNetwork ()->insertHost (workgroup, master);
      if (options ()->scanAllWorkgroups ())
	scanHost (masteritem);
      if ((masteritem) && (wg))
	wg->setMaster (masteritem);
    }

}

/** Fgt Share ein sofern nicht bereits vorhanden */
void
Komba2Doc::InsertShare (const QString & host, const QString & workgroup,
			const QString & share, const QString & comment,
			MyShareItem::ShareTypes sharetyp)
{
  QString pref;
  if ((options ()->hideIpcShares ()) && (sharetyp == MyShareItem::IPC))
    return;
  if ((!options ()->showPrinters ()) && (sharetyp == MyShareItem::Printer))
    return;
  if ((!options ()->showDollarShares ()) && (sharetyp == MyShareItem::Disk)
      && (share[share.length () - 1] == QString ("$")))
    return;
  MyShareItem *shareitem =
    getNetwork ()->insertShare (workgroup, host, share, sharetyp, comment);
  if (shareitem)
    {
      look_for_mounted_Shares (shareitem);
      // MountLastSession
      if ((options ()->mntLastSessionShares () || isCommandOptToMount ())
	  && (!isCommandOptToUnmount ()))
	{
	  if (shareitem->getMountPath ().length () == 0)
	    if (options ()->isToMount (share))
	      Sharemount (shareitem, false);
	}
    }
}

/** Mymaster was found, now search it with smbclient */
void
Komba2Doc::mymasterFound (const QString & name, const QString & workgroup,
			  ulong ip)
{
  if (ip)
    {
      MyHostItem *host = getNetwork ()->insertHost (workgroup, name, ip);
      scanhost->scanHost (host);
    }
}

/**  */
void
Komba2Doc::mymasterIsExited (MyMaster * m)
{
  if (m)
    delete m;
}

void
Komba2Doc::iplookIsExited (IPLook * m)
{
  iplworkingcount--;
  if ((iplworkingcount < 10) && (ipltodolist->count () > 0))
    LookForIP (ipltodolist->pop ());
  if (iplworkingcount < 1)
    slotNoProcess ();
  if (m)
    if (((QListViewItem *) m->getHost ()) ==
	getNetwork ()->listView ()->currentItem ())
      ((Komba2View *) getNetwork ()->listView ()->parent ())->
	setInfoTab (getNetwork ()->listView ()->currentItem ());
  delete m;
}

void
Komba2Doc::LookForIP (MyHostItem * host)
{
  if (host)
    {
      if (iplworkingcount < 10)
	{
	  iplworkingcount++;
	  IPLook *ipl = new IPLook (this, host);
	  connect (ipl, SIGNAL (isExited (IPLook *)), this,
		   SLOT (iplookIsExited (IPLook *)));
	  ipl->getIP ();
	}
      else
	{
	  ipltodolist->push (host);
	}
    }

}

//////////////////////////////////////////////////////////////////////////
//      searchItem()
//      QlistViewItem* item             -       can be host or workgroup
//      bool                            rescan          - force scan                    
//
//      Description :           if item is a host it scans the host
//                                                                      if item is a workgroup it scans master of wg
//                                                                      rescan (default=false) inforces the scan if item
//                                                                      already scanned
//////////////////////////////////////////////////////////////////////////      
void
Komba2Doc::searchItem (QListViewItem * item, bool rescan)
{
  switch (item->depth ())
    {
      // Workgroup
    case 1:
      if (((MyWorkgroupItem *) item)->getMaster ())
	{
	  if (rescan)
	    ((MyWorkgroupItem *) item)->getMaster ()->issearched (false);
	  scanHost (((MyWorkgroupItem *) item)->getMaster ());
	}
      break;
      // Host
    case 2:
      if (rescan)
	((MyHostItem *) item)->issearched (false);
      scanHost ((MyHostItem *) item);
      break;
    }
}

//////////////////////////////////////////////////////////////////////////
//      scanAllChilds()
//      QlistViewItem* item             -       can be network or workgroup
//
//      Description :           scans all Childs (workgroups(master) or hosts)
//////////////////////////////////////////////////////////////////////////      
void
Komba2Doc::scanAllChilds (QListViewItem * item)
{
  QListViewItem *child = item->firstChild ();
  while (child)
    {				// rescan Item (only usefull for workgroup and host
      searchItem (child, true);
      child = child->nextSibling ();
    }
}

bool Komba2Doc::setPassword (QListViewItem * item)
{
  thePassword *
    thepassword =
    0L;
  QString
    title;
  switch (item->depth ())
    {
      // Workgroup
    case 1:
      if (!((MyWorkgroupItem *) item)->askForPassword ())
	return false;
      title = i18n ("Domain-Password : ");
      title.append (((MyWorkgroupItem *) item)->Name ());
      thepassword = new thePassword ((QWidget *) parent (), title);
      thepassword->setSave (options ()->savePasswords ());
      thepassword->setStoreIn (1);
      thepassword->setUsername (((MyWorkgroupItem *) item)->getUsername ());
      thepassword->setPassword (((MyWorkgroupItem *) item)->getPassword ());
      if (thepassword->exec ())
	{
	  ((MyWorkgroupItem *) item)->setAccount (thepassword->username (),
						  thepassword->password ());
	  if (thepassword->save ())
	    options ()->setWorkgroupAccount (((MyWorkgroupItem *) item)->
					     Name (),
					     thepassword->username (),
					     thepassword->password ());
	  if (((MyWorkgroupItem *) item)->getMaster ())
	    ((MyWorkgroupItem *) item)->getMaster ()->issearched (false);
	  delete
	    thepassword;
	  return true;
	}

      delete
	thepassword;
      return false;
      break;
      // Host
    case 2:
      if (!((MyHostItem *) item)->askForPassword ())
	return false;
      title = i18n ("Host-Password : ");
      title.append (((MyHostItem *) item)->Name ());
      thepassword = new thePassword ((QWidget *) parent (), title);
      thepassword->setSave (options ()->savePasswords ());
      thepassword->setStoreIn (2);
      thepassword->setUsername (((MyHostItem *) item)->getUsername ());
      thepassword->setPassword (((MyHostItem *) item)->getPassword ());
      if (thepassword->exec ())
	{
	  switch (thepassword->storeIn ())
	    {
	    case 1:
	      ((MyWorkgroupItem *) item->parent ())->setAccount (thepassword->
								 username (),
								 thepassword->
								 password ());
	      break;
	    case 2:
	      ((MyHostItem *) item)->setAccount (thepassword->username (),
						 thepassword->password ());
	      break;
	    }
	  if (thepassword->save ())
	    switch (thepassword->storeIn ())
	      {
	      case 1:
		options ()->
		  setWorkgroupAccount (((MyWorkgroupItem *) item->parent ())->
				       Name (), thepassword->username (),
				       thepassword->password ());
		break;
	      case 2:
		options ()->setHostAccount (((MyHostItem *) item)->Name (),
					    thepassword->username (),
					    thepassword->password ());
		break;
	      }
	  ((MyHostItem *) item)->issearched (false);
	  delete
	    thepassword;
	  return true;
	}
      else
	{
	  if (KMessageBox::questionYesNo ((QWidget *) parent (),
					  i18n
					  ("Should Komba ask you for  password/user for this host agian ?"),
					  i18n
					  ("Ask for a password next time ?"))
	      == KMessageBox::No)
	    {
	      ((MyHostItem *) item)->setAskForPassword (false);
	      options ()->setHostAccount (((MyHostItem *) item)->Name (),
					  ((MyHostItem *) item)->
					  getUsername (),
					  ((MyHostItem *) item)->
					  getPassword (), false);
	    }
	}
      delete
	thepassword;
      return false;
      break;
      // Share
    case 3:
      if (!((MyShareItem *) item)->askForPassword ())
	return false;
      title = i18n ("Share-Password : ");
      title.append (((MyShareItem *) item)->Name ());
      thepassword = new thePassword ((QWidget *) parent (), title);
      thepassword->setSave (options ()->savePasswords ());
      thepassword->setStoreIn (3);
      thepassword->setUsername (((MyShareItem *) item)->getUsername ());
      thepassword->setPassword (((MyShareItem *) item)->getPassword ());
      if (thepassword->exec ())
	{
	  switch (thepassword->storeIn ())
	    {
	    case 1:
	      ((MyWorkgroupItem *) item->parent ()->parent ())->
		setAccount (thepassword->username (),
			    thepassword->password ());
	      break;
	    case 2:
	      ((MyHostItem *) item->parent ())->setAccount (thepassword->
							    username (),
							    thepassword->
							    password ());
	      break;
	    case 3:
	      ((MyShareItem *) item)->setAccount (thepassword->username (),
						  thepassword->password ());
	      break;
	    }
	  if (thepassword->save ())
	    switch (thepassword->storeIn ())
	      {
	      case 1:
		options ()->
		  setWorkgroupAccount (((MyHostItem *) item->parent ())->
				       getWorkgroupName (),
				       thepassword->username (),
				       thepassword->password ());
		break;
	      case 2:
		options ()->setHostAccount (((MyShareItem *) item)->
					    getHostName (),
					    thepassword->username (),
					    thepassword->password ());
		break;
	      case 3:
		options ()->setShareAccount (((MyShareItem *) item)->
					     getHostName (),
					     ((MyShareItem *) item)->Name (),
					     thepassword->username (),
					     thepassword->password ());
		break;
	      }
	  delete
	    thepassword;
	  return true;
	}
      else
	{
	  if (KMessageBox::questionYesNo ((QWidget *) parent (),
					  i18n
					  ("Should Komba ask you for  password/user for this share agian ?"),
					  i18n
					  ("Ask for a password next time ?"))
	      == KMessageBox::No)
	    {
	      options ()->setShareAccount (((MyShareItem *) item)->
					   getHostName (),
					   ((MyShareItem *) item)->Name (),
					   ((MyShareItem *) item)->
					   getUsername (),
					   ((MyShareItem *) item)->
					   getPassword (), false);
	      ((MyHostItem *) item)->setAskForPassword (false);
	    }
	}
      delete
	thepassword;
      return false;
      break;
    }
  return false;
}

void
Komba2Doc::toggleAskForPassword ()
{
  QListViewItem *item;
  if (getNetwork ())
    {
      item = getNetwork ()->listView ()->currentItem ();
      if (item)
	switch (item->depth ())
	  {
	  case 2:
	    ((MyHostItem *) item)->setAskForPassword (!((MyHostItem *) item)->
						      askForPassword ());
	    options ()->setHostAccount (((MyHostItem *) item)->Name (),
					((MyHostItem *) item)->getUsername (),
					((MyHostItem *) item)->getPassword (),
					((MyHostItem *) item)->
					askForPassword ());
	    break;
	  case 3:
	    ((MyHostItem *) item)->
	      setAskForPassword (!((MyShareItem *) item)->askForPassword ());
	    options ()->setShareAccount (((MyShareItem *) item)->
					 getHostName (),
					 ((MyShareItem *) item)->Name (),
					 ((MyShareItem *) item)->
					 getUsername (),
					 ((MyShareItem *) item)->
					 getPassword (),
					 ((MyShareItem *) item)->
					 askForPassword ());
	    break;
	  }
    }
}

void
Komba2Doc::setAccount ()
{
  QListViewItem *item;
  if (getNetwork ())
    {
      item = getNetwork ()->listView ()->currentItem ();
      if (item)
	setPassword (item);
    }
}

///////////////////////////////////////////////////////////////////////
// Sharemount ()
//      Parameter       :       share - Shareitem wich is mount to
//                                                      explore - if "false" it doenst start konqueror
//                                                                                              if "true" it looks in options->exporeAfterMount
//                                                                                                      and open konqueror if options is true
//                                                      dir                     -       the directory where it is mount to
///////////////////////////////////////////////////////////////////////
void
Komba2Doc::Sharemount (MyShareItem * share, bool explore, QString dir)
{
  Mount *mounter;
  int smbmountversion;
  bool automount = false;
  switch (share->getSharetype ())
    {
    case MyShareItem::Disk:
      if (dir == QString::null)
	{
	  automount = true;
	  dir = getmountpoint (share->getHostName (), share->Name ());
	}
      smbmountversion = options ()->smbMountVersion ();
      if (smbmountversion == 0)
	{
	  KMessageBox::information ((QWidget *) parent (),
				    i18n
				    ("smbmountversion is not set.\nplease set it up in preferences."),
				    "Mount");
	  break;
	}
      if ((share) && (share->getMountPath ().length () == 0))
	{
	  if (explore)
	    explore = options ()->exploreAfterMount ();
	  mounter =
	    new Mount (this, share, smbmountversion, dir, explore, automount);
	  connect (mounter,
		   SIGNAL (isExited (Mount *, QString &, MyShareItem *)),
		   this,
		   SLOT (slotMountIsExited
			 (Mount *, QString &, MyShareItem *)));
	  mountcount++;
	  mounter->start ();
	}
      break;

    case MyShareItem::Printer:
      KMessageBox::information ((QWidget *) parent (),
				i18n ("Sorry, not implemented yet."),
				"Mount");
      break;

    default:
      break;
    }
}

void
Komba2Doc::Shareumount (MyShareItem * share)
{
  Unmount *umounter;
  if (share)
    {
      umounter =
	new Unmount (this, share,
		     (options ()->cleanupOnUnmount ()
		      && share->isAutomount ()));
      connect (umounter,
	       SIGNAL (isExited (Unmount *, QString &, MyShareItem *)), this,
	       SLOT (slotUnmountIsExited
		     (Unmount *, QString &, MyShareItem *)));
      unmountcount++;
      umounter->start ();
    }
}

void
Komba2Doc::slotUnmountIsExited (Unmount * m, QString & err,
				MyShareItem * share)
{

  unmountcount--;
  if (((Komba2App *) parent ())->waitForQuit ())
    {
      if (unmountcount == 0)
	{
	  ((Komba2App *) parent ())->setCanQuit (true);
	  delete m;
	  m = 0;
	  kapp->quit ();
	}
    }
  else
    {
      if (err.length () > 0)
	{
	  err.prepend (i18n ("smbumount exited with errors.\n"));
	  KMessageBox::error ((QWidget *) parent (), err,
			      i18n ("smbumount for //") +
			      share->getHostName () + "/" + share->Name ());
	}
      else if (share)
	{
	  share->setMountPath ("");
	  ((Komba2View *) getNetwork ()->listView ()->parent ())->
	    delMountedShare (share);
	  emit isUnmounted (share);
	}
      if (m)
	delete m;
      if (unmountcount < 1)
	slotNoProcess ();
    }
}


void
Komba2Doc::slotMountIsExited (Mount * m, QString & err, MyShareItem * share)
{
  mountcount--;
  if ((err.contains ("ERR") > 0) || (err.contains ("mount error"))
      || (err.contains ("failed"))
      || (err.contains ("smbmount must be installed suid root")))
    {
      if (err.contains ("ERRbadpw") > 0)
	{
	  if (setPassword ((QListViewItem *) share))
	    Sharemount (share);
	}
      else
	{
	  err.prepend (i18n ("smbmount exited with errors.\n"));
	  KMessageBox::error ((QWidget *) parent (), err,
			      i18n ("smbmount for //") +
			      share->getHostName () + "/" + share->Name ());
	}
    }
  else
    {
      share->setMountPath (m->getMountPath ());
      ((Komba2App *) parent ())->addFileOpenRecent (share);
      ((Komba2View *) getNetwork ()->listView ()->parent ())->
	newMountedShare (share);
      emit isMounted (share);
      if (m->explore ())
	explore (share->getMountPath ());
      delete m;
    }
  if (mountcount < 1)
    slotNoProcess ();
}

/***************************************************************************
 *                                                                         *
 * Opens kfm with given path																				       *
 *                                                                         *
 ***************************************************************************/
void
Komba2Doc::explore (const char *path)
{
  KProcess *p = new KProcess;
  p->clearArguments ();
  (*p) << "kfmclient";
  (*p) << "openURL";
  (*p) << path;
  p->start (KProcess::DontCare, KProcess::NoCommunication);
  delete p;
}

void
Komba2Doc::explore ()
{
  QListViewItem *item = getNetwork ()->listView ()->currentItem ();
  if (item->depth () == 3)	// share
    if (((MyShareItem *) item)->getMountPath ().length () > 0)
      explore (((MyShareItem *) item)->getMountPath ());
}

void
Komba2Doc::ping ()
{
  QListViewItem *item = getNetwork ()->listView ()->currentItem ();
  QString ip;
  Ping *p;
  if (item->depth () == 2)	// host
    if (((MyHostItem *) item)->getNetIP ())
      {
	((MyHostItem *) item)->getIP (&ip);
	p =
	  new Ping (ip, Ping::ProgPing, (QWidget *) parent (),
		    ((MyHostItem *) item)->Name ());
	connect (p, SIGNAL (isClosed (DebugOutput *)), this,
		 SLOT (slotPingIsClosed (DebugOutput *)));
	p->start ();
      }
    else
      KMessageBox::error ((QWidget *) parent (),
			  i18n ("I found no IP so I can't ping the Host."),
			  i18n ("No IP found"));
}

void
Komba2Doc::traceroute ()
{
  QListViewItem *item = getNetwork ()->listView ()->currentItem ();
  QString ip;
  Ping *p;
  if (item->depth () == 2)	// host
    if (((MyHostItem *) item)->getNetIP ())
      {
	((MyHostItem *) item)->getIP (&ip);
	p =
	  new Ping (ip, Ping::ProgTraceroute, (QWidget *) parent (),
		    ((MyHostItem *) item)->Name ());
	connect (p, SIGNAL (isClosed (DebugOutput *)), this,
		 SLOT (slotPingIsClosed (DebugOutput *)));
	p->start ();
      }
    else
      KMessageBox::error ((QWidget *) parent (),
			  i18n ("I found no IP so I can't ping the Host."),
			  i18n ("No IP found"));
}


QString Komba2Doc::getmountpoint (QString nmb_name, QString sharename)
{
  QString
    mountpath;

  // Create the Mountpath if not exits
  mountpath = options ()->mountPath ();
  if (mountpath.isEmpty ())
    {
      KMessageBox::error ((QWidget *) parent (),
			  i18n
			  ("You must set the mount-path in preferences!"),
			  i18n ("Can't create the mountpath"));
      return "";		//Mountpath failed
    }
  QDir
  dir (mountpath);
  if (!dir.exists ())
    {
      if (!dir.mkdir (mountpath))
	{
	  KMessageBox::error ((QWidget *) parent (),
			      i18n ("Problem to create the mountpath."),
			      i18n ("Can't create the mountpath"));
	  return "";		//Mountpath failed
	}
    }
  mountpath += nmb_name.replace (QRegExp (" "), "_");
  dir = mountpath;
  if (!dir.exists ())
    {
      if (!dir.mkdir (mountpath))
	{
	  KMessageBox::error ((QWidget *) parent (),
			      i18n ("Problem to create the mountpath."),
			      i18n ("Can't create the mountpath"));
	  return "";		//Mountpath failed
	}
    }
  mountpath += "/";
  mountpath += sharename.replace (QRegExp (" "), "_");
  dir = mountpath;
  if (!dir.exists ())
    {
      if (!dir.mkdir (mountpath))
	{
	  KMessageBox::error ((QWidget *) parent (),
			      i18n ("Problem to create the mountpath."),
			      i18n ("Can't create the mountpath"));
	  return "";		//Mountpath failed
	}
    }
  return mountpath;
}

/************************************************************
 *     																											*
 *	look for mounted shareitem where mountpath is set			  *
 *     																											*
 ************************************************************/
bool Komba2Doc::look_for_mounted_Shares (MyShareItem * share)
{
  QString
    fstyp,
    mpath,
    resource,
    host,
    sharename;
  QString
    sname,
    hname;
  int
    i;
  QFile
  f ("/etc/mtab");
  if (!f.open (IO_ReadOnly))
    return false;
  QTextStream
  t (&f);
  while (!t.eof ())
    {
      t >> resource;
      t >> mpath;
      t >> fstyp;
      t.readLine ();
      if (fstyp == "smbfs")
	{
	  if (resource.left (2) == "//")
	    if ((i = resource.findRev ("/")) > 2)
	      {
		host = resource.mid (2, i - 2);
		sharename = resource.right (resource.length () - i - 1);
		hname = share->getHostName ();
		hname.replace (QRegExp (" "), "_");
		if (hname == host)
		  {
		    sname = share->Name ();
		    sname.replace (QRegExp (" "), "_");
		    if (sname == sharename)
		      {
			if (share->getMountPath ().length () == 0)
			  {
			    share->setMountPath (mpath);
			    f.close ();
			    emit
			    isMounted (share);
			    ((Komba2View *) getNetwork ()->listView ()->
			     parent ())->newMountedShare (share);
			    return true;
			  }
		      }
		  }
	      }
	}
    }
  f.close ();
  return false;
}

void
Komba2Doc::scannet ()
{
  char iprange[50];
  u_char ip[8];
  u_long ipstart, ipstop, j;

  initPrefHosts ();
  if (options ()->firstIpRange ())
    {
      ((Komba2App *) parent ())->slotStatusMsg (i18n ("Scaning network"));
      do
	{

	  socketservercount++;
	  Socketserver *netprog = new Socketserver (this);
	  connect (netprog, SIGNAL (isExited (Socketserver *)), this,
		   SLOT (socketserverIsExited (Socketserver *)));
	  connect (netprog,
		   SIGNAL (insert_host (char *, char *, u_long, bool)), this,
		   SLOT (InsertHost (char *, char *, u_long, bool)));
	  strncpy (iprange, options ()->currentIpRange (), sizeof (iprange));
	  sscanf (iprange, "%d.%d.%d.%d - %d.%d.%d.%d", (int *) &ip[0],
		  (int *) &ip[1], (int *) &ip[2], (int *) &ip[3],
		  (int *) &ip[4], (int *) &ip[5], (int *) &ip[6],
		  (int *) &ip[7]);
	  ipstart = (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + (ip[3]);
	  ipstop = (ip[4] << 24) + (ip[5] << 16) + (ip[6] << 8) + (ip[7]);
	  for (j = ipstart; j <= ipstop; j++)
	    netprog->getNMBInfo (j, 0);

	}
      while (options ()->nextIpRange ());
    }
  getNetwork ()->setOpen (true);
}

/**  */
void
Komba2Doc::socketserverIsExited (Socketserver * s)
{
  if (s)
    delete s;
  socketservercount--;
  if (socketservercount < 1)
    slotNoProcess ();
}

void
Komba2Doc::initPrefHosts ()
{
  QString hostwg, host, wg;
  MyHostItem *hostitem;
// all in Preferences
  if (options ()->firstHost ())
    {
      do
	{
	  hostwg = options ()->currentHost ();
	  host = hostwg.left (hostwg.find ('\t'));
	  wg = hostwg.right (hostwg.length () - hostwg.find ('\t') - 1);
	  hostitem = getNetwork ()->insertHost (wg, host);
	  scanHost (hostitem);
	}
      while (options ()->nextHost ());
    }
  // all from last session mounted shares
  if (options ()->firstHostOfMntShares ())
    {
      do
	{
	  hostwg = options ()->currentHostOfMntShares ();
	  host = hostwg.left (hostwg.find ('\t'));
	  wg = hostwg.right (hostwg.length () - hostwg.find ('\t') - 1);
	  hostitem = getNetwork ()->insertHost (wg, host);
	  scanHost (hostitem);
	}
      while (options ()->nextHostOfMntShares ());
    }
}

/** init the Hosts in recentmounted */
void
Komba2Doc::initRecentHosts ()
{
  MyHostItem *hostitem;
  QStringList recwglist =
    ((Komba2App *) parent ())->recentMounts ()->getRecentWorkgroups ();
  QStringList rechostlist =
    ((Komba2App *) parent ())->recentMounts ()->getRecentHosts ();
  int count =
    (recwglist.count () <
     rechostlist.count ())? recwglist.count () : rechostlist.count ();
  for (int i = 0; i < count; i++)
    {
      hostitem =
	getNetwork ()->insertHost (recwglist[i], rechostlist[i], 0L, "");
      scanHost (hostitem);
    }
}


/** No descriptions */
void
Komba2Doc::mountAktShare (bool specPath)
{
  QListViewItem *item = getNetwork ()->listView ()->currentItem ();
  if ((item) && (item->depth () == 3))
    {
      if (specPath)
	{
	  QString filename = KFileDialog::getExistingDirectory (QString::null,
								(QWidget *)
								parent (),
								i18n
								("Choose a mountpath"));
	  if (filename != QString::null)
	    ((MyShareItem *) item)->mount (filename);
	}
      else
	{
	  ((MyShareItem *) item)->mount ();
	}
    }
}

/** No descriptions */
void
Komba2Doc::unmountAktShare ()
{
  QListViewItem *item = getNetwork ()->listView ()->currentItem ();
  if ((item->depth () == 3)
      && (((MyShareItem *) item)->getMountPath ().length () > 0))
    Shareumount ((MyShareItem *) item);
}

/* set Password and Username if stored in options */
void
Komba2Doc::setOptionsAccount (QListViewItem * item)
{
  QString username;
  QString password;
  bool ask = true;
  switch (item->depth ())
    {
      // Workgroup
    case 1:
      options ()->getWorkgroupAccount (((MyWorkgroupItem *) item)->Name (),
				       username, password);
      ((MyWorkgroupItem *) item)->setPassword (password);
      ((MyWorkgroupItem *) item)->setUsername (username);
      break;
    case 2:
      options ()->getHostAccount (((MyHostItem *) item)->Name (), username,
				  password, &ask);
      ((MyHostItem *) item)->setPassword (password);
      ((MyHostItem *) item)->setUsername (username);
      ((MyHostItem *) item)->setAskForPassword (ask);
      break;
    case 3:
      options ()->getShareAccount (((MyHostItem *) item->parent ())->Name (),
				   ((MyShareItem *) item)->Name (), username,
				   password, &ask);
      ((MyShareItem *) item)->setPassword (password);
      ((MyShareItem *) item)->setUsername (username);
      ((MyShareItem *) item)->setAskForPassword (ask);
      break;
    }

}

/** it send a netbiosmessage (message) to a netbiosname (netname) */
void
Komba2Doc::sendMessage (const QString & netname, const QString & message)
{
  SendMessage *sm = new SendMessage ((QObject *) this, netname, message);
  connect (sm, SIGNAL (isExited (SendMessage *, QString)), this,
	   SLOT (slotSendMessageIsExited (SendMessage *, QString)));
  sm->start ();
}

void
Komba2Doc::slotSendMessageIsExited (SendMessage * sm, QString err)
{
  if (err.length () > 0)
    KMessageBox::error ((QWidget *) parent (), err, "Error : SendMessage");
  if (sm)
    delete sm;
}


void
Komba2Doc::rescan ()
{
  QListViewItem *item = getNetwork ()->listView ()->currentItem ();
  MyMaster *m;
  if (item)
    {
      if (item->depth () == 1)
	{			//Workgroup
	  ((MyWorkgroupItem *) item)->removeChilds ();
	  scanAllChilds (item);
	  m = new MyMaster (((MyWorkgroupItem *) item)->Name (), this);
	  connect (m,
		   SIGNAL (isMasterName
			   (const QString &, const QString &, ulong)), this,
		   SLOT (mymasterFound
			 (const QString &, const QString &, ulong)));
	  connect (m, SIGNAL (isExited (MyMaster *)), this,
		   SLOT (mymasterIsExited (MyMaster *)));
	  m->getMaster ();
	}
      else if (item->depth () == 2)
	{			//Host
	  ((MyHostItem *) item)->removeChilds ();
	  ((MyHostItem *) item)->issearched (false);
	  searchItem (item);
	  LookForIP ((MyHostItem *) item);
	}
      if (item->depth () == 0)
	{			// Network
	  ((MyNetworkItem *) item)->removeChilds ();
	  scanAllChilds (item);
	  m = new MyMaster (smbconf->getMyWorkgroup (), this);
	  connect (m,
		   SIGNAL (isMasterName
			   (const QString &, const QString &, ulong)), this,
		   SLOT (mymasterFound
			 (const QString &, const QString &, ulong)));
	  connect (m, SIGNAL (isExited (MyMaster *)), this,
		   SLOT (mymasterIsExited (MyMaster *)));
	  m->getMaster ();
	  scannet ();
	}
    }
}

/* try's to send a message to every host in workgroup */
void
Komba2Doc::sendMessage (MyWorkgroupItem * wg, const QString txtmessage)
{
  MyHostItem *host = (MyHostItem *) wg->firstChild ();
  while (host)
    {
      if (!host->isDown ())
	kdDebug (7101) << "sendMessage(" << host->
	  Name () << " , " << txtmessage << ");" << endl;
                              sendMessage(host->Name(), txtmessage );
      host = (MyHostItem *) host->nextSibling ();
    }
}


/* open the Messagedialog and sends Messages (different between host, workgroup, network) */
void
Komba2Doc::sendMessage ()
{
  QListViewItem *item = getNetwork ()->listView ()->currentItem ();
  QString txtmessage, netname;
  Message *m;
  if (item)
    {
      if ((item->depth () == 1) || (item->depth () == 0))
	{
	  m = new Message ((QWidget *) parent (), "message");
	  if (m->exec ())
	    {
	      txtmessage = m->getMessage ();
				if (txtmessage.isEmpty()) return;
	      if (item->depth () == 1)	// Workgroup
		sendMessage ((MyWorkgroupItem *) item, txtmessage);
	      else if (item->depth () == 0)
		{		// Network
		  MyWorkgroupItem *wg =
		    (MyWorkgroupItem *) item->firstChild ();
		  while (wg)
		    {
		      sendMessage (wg, txtmessage);
		      wg = (MyWorkgroupItem *) wg->nextSibling ();
		    }
		}
	    }
	}
      if (item->depth () == 2)
	{			// host
	  QStringList list;
	  ((MyHostItem *) item)->getNetNames (&list, true);
	  if (list.count () > 0)
	    {
	      m = new Message (list, (QWidget *) parent (), "message");
	      int i = m->exec ();
	      if (i)
		{
		  txtmessage = m->getMessage ();
  		if (txtmessage.isEmpty()) return;
		  netname = m->getNetName ();
		  sendMessage (netname, txtmessage);
		}
	      delete m;
	    }
	  else
	    {
	      KMessageBox::error ((QWidget *) parent (),
				  i18n
				  ("No message services found on this host."),
				  i18n ("No Services"));
	    }
	}
    }
}

void
Komba2Doc::slotPingIsClosed (DebugOutput * p)
{
  if (p)
    delete p;
}

void
Komba2Doc::scanHost (MyHostItem * host)
{
  scanhost->scanHost (host);
}

void
Komba2Doc::emitItemRemoved (QListViewItem * item)
{
  emit itemRemoved (item);
}

void
Komba2Doc::slotNoProcess ()
{
  if (!hasOpenProcesses ())
    {
      ((Komba2App *) parent ())->slotStatusMsg (i18n ("Ready"));
      emit noActiveProcess ();
      kdDebug (7199) << "no Active Processes" << endl;
      if (isCommandOptToMount ())
	{
	  kdDebug (7199) << "now try to quit" << endl;
	  kapp->quit ();
	}
      else if (isCommandOptToUnmount ())
	{
	  kdDebug (7199) << "now try to quit" << endl;
	  if (allUnmounted ())
	    kapp->quit ();
	  else if (!UnmountAll (true))
	    kapp->quit ();
	}
    }
}

bool Komba2Doc::hasOpenProcesses ()
{
  return ((scanhost->isWorking ()) || (iplworkingcount > 0)
	  || (unmountcount > 0) || (mountcount > 0));
//              || (socketservercount>0)
}

void
Komba2Doc::setViewSizes (QValueList < int >i)
{
  if (!pViewList->isEmpty ())
    pViewList->first ()->setSplitterPos (i);
}

QValueList < int >
Komba2Doc::getViewSizes ()
{
  QValueList < int >nothing;
  if (!pViewList->isEmpty ())
    return pViewList->first ()->getSplitterPos ();
  return nothing;

}

/**
*  Unmount all shares if options()->unmountAllOnExit() == true
*/
bool Komba2Doc::UnmountAll (bool action)
{
  MyNetworkItem *
    netitem;
  MyWorkgroupItem *
    wgitem;
  MyHostItem *
    hostitem;
  MyShareItem *
    shareitem;
  bool
    unmounts =
    false;
  if ((options ()->unmountAllOnExit ()) || (action))
    {
      options ()->clearShareToMount ();
      netitem = getNetwork ();
      wgitem = (MyWorkgroupItem *) netitem->firstChild ();
      while (wgitem)
	{
	  hostitem = (MyHostItem *) wgitem->firstChild ();
	  while (hostitem)
	    {
	      shareitem = (MyShareItem *) hostitem->firstChild ();
	      while (shareitem)
		{
		  if (!shareitem->getMountPath ().isEmpty ())
		    {
		      if (!action)
			{
			  options ()->appendShareToMount (shareitem->
							  getWorkgroupName (),
							  shareitem->
							  getHostName (),
							  shareitem->Name ());
			}
		      Shareumount (shareitem);
		      unmounts = true;
		    }
		  shareitem = (MyShareItem *) shareitem->nextSibling ();
		}
	      hostitem = (MyHostItem *) hostitem->nextSibling ();
	    }
	  wgitem = (MyWorkgroupItem *) wgitem->nextSibling ();
	}
    }
  if ((unmounts) && (!action))
    options ()->saveShareToMount ();
  allunmounted = true;
  return unmounts;
}

/**
*  Mount all shares 
*/
void
Komba2Doc::MountAll ()
{
  MyNetworkItem *netitem;
  MyWorkgroupItem *wgitem;
  MyHostItem *hostitem;
  MyShareItem *shareitem;

  Komba2App *win = (Komba2App *) parent ();
  int want_mount = KMessageBox::questionYesNo (win,
					       i18n
					       ("Do you realy want mount all \nfound shares in network ?\n"),
					       i18n ("You are sure ?"));
  if (want_mount == KMessageBox::Yes)
    {
      netitem = getNetwork ();
      wgitem = (MyWorkgroupItem *) netitem->firstChild ();
      while (wgitem)
	{
	  hostitem = (MyHostItem *) wgitem->firstChild ();
	  while (hostitem)
	    {
	      shareitem = (MyShareItem *) hostitem->firstChild ();
	      while (shareitem)
		{
		  if ((shareitem->getMountPath ().isEmpty ())
		      && (shareitem->getSharetype () == MyShareItem::Disk))
		    {
		      Sharemount (shareitem, false);
		    }
		  shareitem = (MyShareItem *) shareitem->nextSibling ();
		}
	      hostitem = (MyHostItem *) hostitem->nextSibling ();
	    }
	  wgitem = (MyWorkgroupItem *) wgitem->nextSibling ();
	}
    }

}


bool Komba2Doc::isCommandOptToMount ()
{
  return (comOpt == optMount);
}

bool Komba2Doc::isCommandOptToUnmount ()
{
  return (comOpt == optUnmount);
}

/*  Method allUnmounted
 *	return 	true if UnmountAll was used
*/
bool Komba2Doc::allUnmounted ()
{
  return allunmounted;
}
