/***************************************************************************
 *   Copyright (C) 2005-2008 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kio/job.h>
#include <kio/netaccess.h>
#include <klocale.h>

#include "kfileitemext.h"

#include "komparatorremovejob.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

KomparatorRemoveJob::KomparatorRemoveJob( QWidget *_parent )
	: KomparatorJob( _parent )
{
	m_status = "";
}

KomparatorRemoveJob::~KomparatorRemoveJob()
{
}

bool KomparatorRemoveJob::initialize( KURL::List *url_list, bool trash_files, QString status )
{
	if ( url_list->count() == 0 ) return false;

	m_mutex.lock();

	m_url_list = *url_list;
	m_finished_list.clear();
	m_trash_files = trash_files;
	m_status = status;

	m_initialized = true;
	m_canceled = false;

	m_mutex.unlock();

	return true;
}

void KomparatorRemoveJob::run()
{
	if ( !m_initialized ) return;

	emitProgress( m_status, -1 );

	if ( !isCanceled() )
	{
		QCustomEvent *event = new QCustomEvent( RESULT_REMOVE_FINISHED );
		QApplication::postEvent( m_parent, event );
	}

	m_initialized = false;
}

void KomparatorRemoveJob::slotFinished( KIO::Job *job )
{
}

const KURL::List &KomparatorRemoveJob::getFinishedList()
{
	return m_finished_list;
}
