 /***************************************************************************
                          plugin_katespeaker.h  -  description
                             -------------------
    begin                :  07 17 2001
    copyright            : (C) 2001 by Matteo Merli
    email                : merlim@libero.it
 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _PLUGIN_KATESPEAKER_H
#define _PLUGIN_KATESPEAKER_H

#include <qstring.h>

#include <kate/plugin.h>
#include <kate/application.h>
#include <kate/view.h>
#include <kate/document.h>
#include <kate/documentmanager.h>
#include <kate/mainwindow.h>
#include <kate/viewmanager.h>

#include <klibloader.h>

class KatePluginFactory : public KLibFactory
{
	Q_OBJECT

public:
	KatePluginFactory();
	virtual ~KatePluginFactory();

	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
			const char* name = "QObject", const QStringList &args = QStringList() );

private:
	static KInstance* s_instance;
};

class PluginKateSpeaker : public Kate::Plugin, Kate::PluginViewInterface
{
	Q_OBJECT
public:
	PluginKateSpeaker( QObject* parent = 0, const char* name = 0 );
	virtual ~PluginKateSpeaker();

	void addView( Kate::MainWindow *win);
	void removeView( Kate::MainWindow *win);

public slots:
	void slotSpeak();

private:
	QPtrList<class PluginView> m_views;
};

#endif // _PLUGIN_KATESPEAKER_H
