/***************************************************************************
                          jabberid.h  -  description                              
                             -------------------                                         
    begin                : Thu May 18 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


 /*
   	A JID parser
 */

#ifndef JABBERID_H
#define JABBERID_H

#include <qstring.h>

#include <stdio.h>


/**
  * This parses jabber ids.  Jabber ids are in a [node@]domain[/resource] format.
  *
  *@author Seth Hartbecke
  * @short A Jabber ID parser, it also can build them.
  */

class JabberID
{
public:
	JabberID();
	/**
	 * In [node@]domain[/resource] format
	 */
	JabberID( QString jid );
	JabberID( QString node, QString domain, QString resource );
        JabberID( JabberID &jid );

	/**
	 * Returns jabber id strings.
	 */
	QString getJID(); //In [node@]domain[/resource] format

	QString getNode();
	QString getDomain();
	QString getResource();

	JabberID operator=(QString& jid);

private:
	void parse( QString jid );

	QString _node;
	QString _domain;
	QString _resource;
};

#endif
