/***************************************************************************
                          userpresence.h  -  description                              
                             -------------------                                         
    begin                : Fri Jan 7 2000                                           
    copyright            : (C) 2000 by Seth Hartbecke                         
    email                : gandalf@netins.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef USERPRESENCE_H
#define USERPRESENCE_H

#include <qwidget.h>
#include <qobject.h>
#include <user.h>
#include <qtimer.h>
#include <qpixmap.h>

#include <jabbercore.h>

/**
  * Presence info for the User info database
  *
  * This stores information about one presence for one user.  Simple but effective.
  * Usually you get access to one of these objects via the user object it is related to
  *
  * @author Seth Hartbecke (gandalf@netins.net)
  * @see User
  */

class UserPresence
	: public QObject  {
   Q_OBJECT
public:
        /**
	 * Default constructor, called by the User object that has information to be stored.
	 */
	UserPresence(User *u, QString resource);
	~UserPresence();

	/**
	 * Retrieve the name of the resource
	 */
	QString resourceName() { return txtResource; };
	/**
	 * A pointer to the user object that created this object (the user this presence is for)
	 */
	User *getUser() { return user; };
	/**
	 * Returns the status string of the user's most recenent presence packet
	 */
	QString status() { return txtStatus; };
	/**
	 * Returns the priority component of the presence's mose recent presence packet
	 */
	int priority() {return intPriority; };
	/**
	 * Returns if the user presence is currently available (online).
	 */
	bool available() { return isAvailable; };
	/**
	 * Returns the current status type for this presence
	 */
        JabberCore::StatusType getShow() { return _show; };
	/**
	 * Just want to know which icon to show, just call this and you have the right one.
	 */
        QPixmap getIcon();


signals:
        /**
	 * Connect to this signal if you are interested in when this presence goes online/offline
	 * or changes thier presence in any way
	 */
	void presenceChanged(User *u, UserPresence *p);
	/**
	 * Connect to this signal if you want to be notified when this presence record is being deleted
	 * from the user database stored in the client
	 */
        void presenceDeleted(User *u, UserPresence *p);

public slots:
        /**
	 * Presence tags are passed on to here so that
         *  this object can update its internal state
	 */
	void processPresence(XMLNode *t);

private slots:
	void deleteTimeout() { delete this; };

private:
	User *user;
	QString txtResource;
	QString txtStatus;
	int intPriority;
        JabberCore::StatusType _show;
	bool isAvailable;
        QTimer *deleteTimer;
};

#endif
