/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) YEAR by AUTHOR
    email                : EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef XMLTAG_H
#define XMLTAG_H

#include <qstring.h>
#include <qregexp.h>
#include <qlist.h>

#include <stdio.h>
#include <string.h>

/**
  * This class allows for easy use of XMLNodes (and it creates them too!).
  *
  * It has some problems, and is not 100% complient, but it does the job for the
  * jabber protocol.
  *@author Seth Hartbecke (gandalf@netins.net)
*/


class XMLNode
{
public:
        /**
	 * Constructs a new, completely empty, node (no name, attributes, value, child nodes, nothing).
	 */
	XMLNode();
	/**
	 * Constructs a new new nodes and sets it's name to the specified parameter
	 */
	XMLNode(QString name);
	/**
	 * Creates a new node, and then copies the node you passed (creates copies of all the child
	 * nodes too).
	 */
	XMLNode( XMLNode &n );
	~XMLNode();

	/**
	 * Gets the "name" of the node.  If you tag is <message ...>..</message> then the name is message.
	 */
	QString getName();
	/**
	 * Set the name of the XMLNode
         */
	void setName(QString s);


	/**
	 * Tells you how many attributes are on this node.  Great if you need to loop through all of them.
	 */
	int numberAttributes();
	/**
	 * Returns the value of the attribute you ask for.
	 */
	QString getAttribute(QString attribute);
	/**
	 * Sets attriube a to value v.  If you already have an attribute by that name the old value will be
	 * over written.
	 */
	void setAttribute(QString a, QString v);
	/**
	 * Returns the attribute name and value of the nth attribute.  If you pass in a n value that is out of range
	 * (ie, bigger then the number of attributes on the node) the behavior is undefined (bet on it crashing).
	 */
	void getAttributePair( int n, QString &attribute, QString &value );

	/**
	 * Returns the number of child nodes on this node.
	 */
	int numberChildNodes();
	/**
	 * Attach this child node, note that it does not make a copy (so it is not a good idea to delete
	 * the child node pointer after calling addChildNode).
	 */
	void addChildNode(XMLNode *t);
	/**
	 * Get the nth child node
	 */
	XMLNode *getChildNode(int n);
	/**
	 * Get the first child node that who's name matches, if autoCreate is true (default) and it was
	 * unable to find match, it will create a child node for you.
	 *
	 * Yea, I know this may not look like a good thing at first, but it really makes some thing simpler.
	 */
	XMLNode *getChildNode(QString name, bool autoCreate = true);
	/**
	 * Delete the nth child node.
	 */
	void deleteChildNode(int n);

	/**
	 * Retuns the value.
	 *
	 * <pre>
	 * <tag>Value is this part</tag>
	 * </pre>
	 *
	 * Something to note, if the node has child nodes, then the value is null.
	 */
	QString getValue();
	/**
	 * Sets the value of this node
	 */
	void setValue(QString s);

	/**
	 * Returns valid XML ready to send, store, ect.
	 */
	QString getXML();

	/**
	 * This will do the standard XML escaping stuff (like changing < to &lt;).
	 */
	static QString escape(QString s);
	/**
	 * This undoes the XML escaping stuff (change &lt; back to <)
	 */
	static QString descape(QString s);
	/**
	 * Super awesome debug function.  Give this an XMLNode and it will print it out in the screen
	 * in a format that is easy to read (this is what currently formats all the debug output)
	 */
	static void printXML(XMLNode *t, int tabLevel = 0);
private:
	struct AttributePair
	{
		QString parameter;
		QString value;
	};
	
	QString XMLText;
	QString tagName;
	QString tagValue;

	QList<XMLNode> childNodes;
	QList<AttributePair> attributes;	
};



#endif

