//                       -*- mode: C++ -*-
//
// Copyright(C) 2007 Stefan Siegl <stesie@brokenpipe.de>
//
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef KOPETESILC_SILCBUDDYCLIENTENTRY_H
#define KOPETESILC_SILCBUDDYCLIENTENTRY_H

#include <QList>

// forward declare SilcTK::SilcClientEntry
namespace SilcTK {
  struct SilcClientEntryStruct;
  typedef struct SilcClientEntryStruct *SilcClientEntry;
}

class SilcChannelContact;
class SilcBuddyContact;

class SilcBuddyClientEntry : public QList<SilcTK::SilcClientEntry> {
public:
  SilcBuddyClientEntry(SilcBuddyContact *, bool temp = false);
  virtual ~SilcBuddyClientEntry();

  /**
   * @short return the active client entry (marked const)
   */
  SilcTK::SilcClientEntry operator() (void) const;
  
  /**
   * @short return the active client entry
   */
  SilcTK::SilcClientEntry operator() ();

  /**
   * @short return one client entry, that is joined into the given channel
   */
  SilcTK::SilcClientEntry operator() (SilcChannelContact *);

  /**
   * @short mark client entry with the given index as active
   */
  void setActive(int);

  /**
   * @short mark the given client entry as active
   */
  void setActive(SilcTK::SilcClientEntry);

  /**
   * @short the index of the client entry marked active
   */
  int active(void) const 
  {
    return _active;
  }

  /**
   * @short return a pointer to the SilcBuddyContact these client entries
   * belong to
   */
  SilcBuddyContact *buddy(void)
  {
    return _buddy;
  }

  /**
   * @short return a pointer to the SilcBuddyContact these client entries
   * belong to (const variant)
   */
  const SilcBuddyContact *buddy(void) const
  {
    return _buddy;
  }

  /**
   * @short replace the old SilcClientEntry with the new one
   */
  void replace(SilcTK::SilcClientEntry oldce, SilcTK::SilcClientEntry newce);

  /**
   * @short return a list of all those client entries joined into the
   * given channel
   */
  SilcBuddyClientEntry joinedTo(SilcChannelContact *);

  /**
   * @short Insert a client entry at the end of the list.
   */
  void append(SilcTK::SilcClientEntry);

  /**
   * @short Removes all occurences of the client entry from the list.
   */
  int removeAll(SilcTK::SilcClientEntry);

  /**
   * @short Removes all client entries from the list.
   */
  void clear(void);

private:
  /**
   * @short choose an arbitrary SilcClientEntry
   */
  int chooseActive(void) const;

  int _active;
  SilcBuddyContact *_buddy;
  bool _isTemporary;
};


#endif /* KOPETESILC_SILCBUDDYCLIENTENTRY_H */
