// Copyright(C) 2005,2006 Stefan Siegl <stesie@brokenpipe.de>
// Copyright(C) 2006 Martin Albrecht <malb@informatik.uni-bremen.de>
//
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "ui_silcbuddycontactinfo.h"

#include "silcbuddycontactinfowidget.h"
#include "silcbuddycontact.h"
#include "silcbuddyattributes.h"

#include <kdebug.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>

SilcBuddyContactInfoWidget::SilcBuddyContactInfoWidget(SilcBuddyContact *b)
  : _buddy(b)
{
  _dlg = new Ui::SilcBuddyContactInfo();
  _dlg->setupUi(this);

  b->whoami();

  _dlg->fingerprint->setText(b->fingerprint());
  _dlg->fpTrusted->setChecked(b->fpTrusted());
  _dlg->chkAllowRichText->setChecked(b->allowRichText());

  // fill refreshworthy widgets ...
  updateDialog(b->nickName(), b->userName(), b->realName());

  QObject::connect((QObject *) _dlg->buttonApply, SIGNAL(clicked()),
		   this, SLOT(slotApply()));
  QObject::connect((QObject *) _dlg->buttonOk, SIGNAL(clicked()),
		   this, SLOT(slotOk()));
  QObject::connect((QObject *) _dlg->buttonCancel, SIGNAL(clicked()),
		   this, SLOT(slotCancel()));

  QObject::connect
    ((QObject *)b, SIGNAL(signalWhois(QString, QString, QString)),
     this, SLOT(slotWhois(QString, QString, QString)));

  show();
}

SilcBuddyContactInfoWidget::~SilcBuddyContactInfoWidget()
{
  delete _dlg;
}

void
SilcBuddyContactInfoWidget::slotApply(void)
{
  _buddy->setFpTrusted(_dlg->fpTrusted->isChecked());
  _buddy->setAllowRichText(_dlg->chkAllowRichText->isChecked());
}

void
SilcBuddyContactInfoWidget::slotOk(void)
{
  slotApply();
  delete this;
}

void
SilcBuddyContactInfoWidget::slotCancel(void)
{
  delete this;
}

void
SilcBuddyContactInfoWidget::slotWhois(QString _nickname, QString _username,
				      QString _realname)
{
  updateDialog(_nickname, _username, _realname);
}

void
SilcBuddyContactInfoWidget::updateDialog(const QString _nickname, 
					 const QString _username,
				         const QString _realname)
{
  _dlg->nickname->setText(QString("%1 (%2)").arg(_nickname).arg(_username));
  _dlg->realname->setText(QString(_realname));
  _dlg->update->setText(QDateTime::currentDateTime().
		        toString("dd.MM.yyyy hh:mm:ss"));

  // show list of channels ...
  _dlg->channels->setText(_buddy->channelList().join(" "));

  // Show Attributes 
  _dlg->labelAttributes->setText(_buddy->attributes().getInformations()); 
}


#include "silcbuddycontactinfowidget.moc"

