
#include <kore/version.h>
#include <kore/servicemanager.h>

#include <Application.h>
#include <Alert.h>

#include "koredlg_be.h"

#define KDBE_MAJOR 0
#define KDBE_MINOR 0
#define KDBE_REVISION 1
#define KDBE_VERSION "0.0.1"
#define KDBE_API_MAJOR 0
#define KDBE_API_MINOR 0
#define KDBE_API_REVISION 2
#define KDBE_API_VERSION "0.0.2"
#define KDBE_NAME "KoreDialog <BeOS>"
#define KDBE_TYPE KOREDLG_TYPE
#define KDBE_DESCRIPTION "BeOS-based implementation for KoreDialog"
#define KDBE_SERVICE KOREDLG_SERVICE "/be"
#define KDBE_SERVICE_DESCRIPTION "BeOS-based '" KOREDLG_SERVICE "' service"

KoreDlg_be::KoreDlg_be()
{
    _kdbeVersion = new Version(KDBE_MAJOR,KDBE_MINOR,KDBE_REVISION,KDBE_VERSION);
    _kdbeAPIVersion = new Version(KDBE_API_MAJOR,KDBE_API_MINOR,KDBE_API_REVISION,KDBE_API_VERSION);
    _kdbeInfo = new Info(this, KDBE_NAME, KDBE_TYPE, KDBE_DESCRIPTION, _kdbeVersion, _kdbeAPIVersion);
    setInfo(_kdbeInfo);
    _kdbeService = new Service(this, KDBE_SERVICE, KDBE_SERVICE_DESCRIPTION);
    addService(_kdbeService);
    _kdService = new Service(this, KOREDLG_SERVICE, KDBE_SERVICE_DESCRIPTION);
    addService(_kdService);
}
KoreDlg_be::~KoreDlg_be()
{
    delete _kdbeInfo;
    delete _kdbeVersion;
    delete _kdbeAPIVersion;
    delete _kdbeService;
    delete _kdService;
}

void KoreDlg_be::showMessage(const char *msg)
{
    new BApplication("application/x-vnd.koredlg-be");
    BAlert *dlg = new BAlert(KDBE_NAME, msg, "Ok");
    dlg->Go();
    delete be_app;
}
