
#ifndef MODULEVIEWFACTORY_H
#define MODULEVIEWFACTORY_H

#include <kore/serviceprovider.h>
#include "moduleview.h"

#define MODULEVIEWFACTORY_TYPE "ModuleView Factory"
#define MODULEVIEWFACTORY_SERVICE "Kore/UI/Module View/Factory"

class QWidget;
typedef uint WFlags;

class ModuleViewFactory: public ServiceProvider
{
public:
    ModuleViewFactory() { };
    virtual ~ModuleViewFactory() { };

    virtual ModuleView* createView( kore::Module* mod, QWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0 ) = 0;
    virtual ModuleView* reuseView( kore::Module* mod, QWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0 ) = 0;
    virtual void destroyViews() = 0;
};

#endif
