#ifndef DSPOUTOSS_H_INCLUDED
#define DSPOUTOSS_H_INCLUDED

#include <sys/soundcard.h>
#include "dspout.h"

/**
 * @short OSS implementation of DspOut.
 * @author Billy Biggs <vektor@div8.net>
 *
 * This is the OSS implementation of DspOut for the /dev/dsp*
 * devices.  Note that you cannot change how many fragments
 * this class requests, yet.
 */
class DspOutOss : public DspOut
{
public:
	/**
	 * Constructs a DspOutOss object representing the given
	 * filename.  Default is /dev/dsp.
	 */
	DspOutOss( const QString &fileName = "/dev/dsp" );

	/**
	 * Destructor.  Will close the device if it is open.
	 */
	virtual ~DspOutOss( void );

	bool openDevice( DeviceMode mode );
	bool openDevice( int exist_fs );
	bool writeBuffer( void );
	unsigned int readableBytes( void );
	bool readBuffer( int bytes );
	int audio_fd;

private:
	QString filename;         // device filename
	bool audio_stereo;
};

#endif  // DSPOUTOSS_H_INCLUDED
