//
// C++ Interface: kpgaggregate
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGAGGREGATE_H
#define KPGAGGREGATE_H

#include "kpgtreeitem.h"

class KPGAggregatesFolder;

/**
  * Aggregate function. An aggregate function is a function that operates on a * set of values (typically one column from each row that matches a query 
  * condition) and returns a single value computed from all these values.
  *
  * Typical aggregate functions are sum, count, and max. Each entry in
  * pg_aggregate is an extension of an entry in pg_proc. The pg_proc entry
  * carries the aggregate's name, input and output data types, and other
  * information that is similar to ordinary functions. 
  *
  * @author Lumir Vanek
  */
class KPGAggregate : public KPGTreeItem
{
public:
    KPGAggregate(KPGAggregatesFolder *, const QString);
	KPGAggregate(KPGAggregatesFolder *, KPGAggregate *, const QString);
    ~KPGAggregate();

    virtual eNodeType type() const { return nodeAggregate; }
	void setProperties(const pqxx::result::tuple &);
			 
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return; }
		
	/*
	 * Functions for accessing properties
	 */
	 
	pqxx::oid oidAggregateFn() const { return m_oidAggregateFn; }
	const QString & aggregateFn() const { return m_strAggregateFn; }	
	const QString & description() const { return m_strDescription; }
	const QString & owner() const { return m_strOwner; }
	pqxx::oid oidTransFn() const { return m_oidTransFn; }
	const QString & transFn() const { return m_strTransFn; }
	pqxx::oid oidFinalFn() const { return m_oidFinalFn; }
	const QString & finalFn() const { return m_strFinalFn; }
		
	pqxx::oid oidInputType() const { return m_oidInputType; }
	const QString & inputTypName() const { return m_strInputTypName; }
	pqxx::oid oidTransType() const { return m_oidTransType; }
	const QString & transTypName() const { return m_strTransTypName; }
	pqxx::oid oidRetType() const { return m_oidRetType; }
	const QString & retTypName() const { return m_strRetTypName; }
		
	const QString & initVal() const { return m_strInitVal; }
	
protected:

	/*
	 * Properties
	 */
	pqxx::oid m_oidAggregateFn;
	QString m_strAggregateFn;
	QString m_strDescription;
	QString m_strOwner;
	pqxx::oid m_oidTransFn;
	QString m_strTransFn;
	pqxx::oid m_oidFinalFn;
	QString m_strFinalFn;
		
	pqxx::oid m_oidInputType;
	QString m_strInputTypName;
	pqxx::oid m_oidTransType;
	QString m_strTransTypName;
	pqxx::oid m_oidRetType;
	QString m_strRetTypName;
		
	QString m_strInitVal;
};

#endif
