//
// C++ Interface: kpgcast
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCAST_H
#define KPGCAST_H

#include "kpgobject.h"

class KPGCastsFolder;

/**
  * Item that represent cast. A cast specifies how to perform 
  * a conversion between two data types.
  *
  * @author Lumir Vanek
  */
class KPGCast : public KPGObject
{
public:
    KPGCast(KPGCastsFolder *, const QString, pqxx::oid);
	KPGCast(KPGCastsFolder *, KPGCast *, const QString, pqxx::oid);
    ~KPGCast();

	virtual eNodeType type() const { return nodeCast; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "CAST"; }
	
	void setProperties(const pqxx::result::tuple &);
		
	// Refresh item, and also childs objects
	void refresh() throw(const KPGSqlException &) { return; }

	/*
	 * Functions for accessing properties
	 */
	const QString & context() const { return m_strContext; }
	pqxx::oid oidSourceType() const { return m_oidSourceType; }
	const QString & sourceType() const { return m_strSourceType; }
	pqxx::oid oidTargetType() const { return m_oidTargetType; }
	const QString & targetType() const { return m_strTargetType; }
	pqxx::oid oidCastFunc() const { return m_oidCastFunc; }
	const QString & castFunc() const { return m_strCastFunc; }
	pqxx::oid oidNameSpace() const { return m_oidNameSpace; }
	const QString & nameSpace() const { return m_strNameSpace; }
	
protected:

	/*
	 * Properties
	 */
	QString m_strContext;
	pqxx::oid m_oidSourceType;
	QString m_strSourceType;
	pqxx::oid m_oidTargetType;
	QString m_strTargetType;
	pqxx::oid m_oidCastFunc;
	QString m_strCastFunc;
	pqxx::oid m_oidNameSpace;
	QString m_strNameSpace;
};

#endif
