//
// C++ Implementation: kpgtableitemsfolder
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtableitemsfolder.h"

// include files for KDE
#include <klistbox.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <kcursor.h>

#include "kpgitemsfolder.h"
#include "../kpgsqldialog.h"

KPGTableItemsFolder::KPGTableItemsFolder(KPGTable *parent, const QString & name)
  : KPGTreeItem(parent, name)
{
	m_bIsLoaded = false;
  	setPixmap(0, *m_pIconFolderBlue);
}

KPGTableItemsFolder::KPGTableItemsFolder(KPGTable *parent, KPGTableItemsFolder *after, const QString & name)
  : KPGTreeItem(parent, after, name)
{
  	m_bIsLoaded = false;
  	setPixmap(0, *m_pIconFolderBlue);
}

KPGTableItemsFolder::~KPGTableItemsFolder()
{
}

void KPGTableItemsFolder::activate()
{
	if(!m_bIsLoaded)
	{ 
		listView()->setCursor(KCursor::waitCursor());
		try
		{
			refresh();
		}
		catch (const KPGSqlException &e)
		{
			listView()->setCursor(KCursor::arrowCursor());
			KPGSqlDialog dlg(0, e.getSql(), e.what());
			dlg.exec();
		}
		listView()->setCursor(KCursor::arrowCursor());
		setOpen(true);
	}
}

void KPGTableItemsFolder::refresh() throw(const KPGSqlException &)
{
	KPGTreeItem * pItemParent = static_cast <KPGTreeItem *> (parent());
	if(!pItemParent)
	{ 
	   kdError() << "Failed to find DB connection " << endl;
	   return;
	}
	
	refresh((static_cast <KPGTable *> (pItemParent))->oid());
	
	m_bIsLoaded = true;
}

void KPGTableItemsFolder::fillListBoxWithChildItems(QListBox *pListBox)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem); 
		
		pListBox->insertItem(new KPGListBoxItem(* pTreeItem->pixmap(0), pTreeItem->text(0), pTreeItem->type()));    
		
		pItem = pItem->nextSibling();
	}
}

void KPGTableItemsFolder::fillListBoxWithChildItems(KListBox *pListBox)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		KPGTreeItem *pTreeItem = static_cast <KPGTreeItem *> (pItem); 
		
		pListBox->insertItem(new KPGListBoxItem(* pTreeItem->pixmap(0), pTreeItem->text(0), pTreeItem->type()));    
		
		pItem = pItem->nextSibling();
	}
}

void KPGTableItemsFolder::fillComboBoxWithChildItems(KComboBox *pComboBox)
{
	QListViewItem * pItem = firstChild();
	while(pItem)
	{
		pComboBox->insertItem(* pItem->pixmap(0), pItem->text(0));   
		
		pItem = pItem->nextSibling();
	}
}
