/***************************************************************************
                          kpgview.cpp  -  description
                             -------------------
    begin                : Po led 19 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgview.h"
 
// include files for KDE
#include <kdebug.h>
#include <klocale.h>

#include "kpgdatabase.h"
#include "kpgviewsfolder.h"


KPGView::KPGView(KPGViewsFolder *parent, const QString name, pqxx::oid _oid)
 : KPGObject(parent, name, _oid)
{
	setPixmap(0, *m_pIconView);
}

KPGView::KPGView(KPGViewsFolder *parent, KPGView *after, const QString name, pqxx::oid _oid)
 : KPGObject(parent, after, name, _oid)
{
	setPixmap(0, *m_pIconView);
}

KPGView::~KPGView()
{
}

void KPGView::setProperties(
	const QString strOwner, 
	const QString strACL,
	const QString strDescription
	)
{
	m_strOwner = strOwner;
	m_strACL = strACL;
	m_strDescription = strDescription;
}

// Refresh only view info, without childs objects
void KPGView::refreshItem() throw(const KPGSqlException &)
{
	// Get pointer to server for version info
	//KPGDatabase *pDatabase = static_cast <KPGDatabase *> (parent()->parent()->parent());
	
	// obtain info about of view
	QString strQuery("SELECT c.oid, c.relname, description, pg_get_userbyid(c.relowner) AS viewowner, c.relacl ");
	strQuery.append("FROM pg_catalog.pg_class c ");
	strQuery.append("LEFT OUTER JOIN pg_catalog.pg_description des ON (des.objoid=c.oid and des.objsubid=0) ");
	
	strQuery.append("WHERE c.oid = " + QString("%1").arg(m_oid));
		
	try
	{
		pqxx::result pqxxResultViews = connection()->runQuery(strQuery);
	
		if(pqxxResultViews.size() != 1)
		{
			kdError() << k_funcinfo "Expect one row in result !" <<  endl;
			return;
		}
		
		setProperties(
		pqxxResultViews[0]["viewowner"].c_str(), 
		pqxxResultViews[0]["relacl"].c_str(),
		pqxxResultViews[0]["description"].c_str()
		);
			
		//-- Get definition
		strQuery = QString("SELECT pg_get_viewdef(%1) AS definition;").arg(m_oid);
		pqxx::result pqxxResultDefinition = connection()->runQuery(strQuery);
		
		if (pqxxResultDefinition.size() > 0)
		{ 
			setDefinition(pqxxResultDefinition[0][0].c_str());
		} 
	}
	catch (const std::exception &e)
	{
		kdError() << k_funcinfo << e.what() << endl;
		throw KPGSqlException(e.what(), strQuery);
	} 
}

