//
// C++ Implementation: kpgdebugger
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdebugger.h"

// include files for Qt
#include <qwidgetstack.h> 
#include <qtextcodec.h>

// include files for KDE
#include <klocale.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kcursor.h>
#include <kdebug.h>
#include <kcombobox.h>

// include files for KatePart
#include <kate/document.h>  // KatePart document

// application specific includes
#include "../kpgutil.h"
#include "../kpogreview.h"
//#include "../kpgconfiguration.h"
//#include "../QueryResult/kpgsqleditorsettings.h"
#include "../DbObjects/kpgconnection.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgfunction.h"
#include "../kpgsqldialog.h"
#include "../DbObjects/kpgtablecolumn.h"
#include "kpgdebuggerchildview.h"

// http://www.kexi-project.org/docs/svn-api/html/kexieditor_8cpp-source.html
// /opt/kde3/share/doc/HTML/en/kdelibs-apidocs/index.html

KPGDebugger::KPGDebugger(KPGDebuggerChildView *pParent, 
	KPoGreView *pPoGreView,
	KParts::Factory *pKatePartFactory,
	KXMLGUIFactory *pXmlGuiFactory,
	KPGConnection *pConnection, 
	const QString & strNamespaceName, 
	KPGFunction *pFunction  // TODO passing pointer is dangerous, function may be dropped !
	)
	: 
	KXMLGUIClient(pPoGreView),
	KPGDebuggerBase(pParent, "KPGDebugger")
{
	m_pConnection = pConnection;
	m_strNamespaceName = strNamespaceName;
	m_strFunctionName = pFunction->text(0);
	
	// Make own copy of arguments info
	m_listArguments = pFunction->listArguments();
	
	// Setup GUI
	setXMLFile("kpgdebugger.rc", true);
	m_pXmlGuiFactory = pXmlGuiFactory;
	m_bIsAddedToGuiFactory = false;

	//-----------------------------------------------------------------
	// Debugger actions
	m_pActRun = new KAction(i18n("Start in debugger"), "dbgrun", Key_F9, this, SLOT(slotExecute()), actionCollection(),
"debugger_start");
	
	m_pActStop = new KAction(i18n("Stop"), "stop", 0, this, SLOT(slotStop()), actionCollection(), "debugger_stop");
  	
  	m_pActStepOver = new KAction(i18n("Step &Over"), "dbgnext", Key_F10, this, SLOT(slotStepOver()), actionCollection(),
"debugger_step_over");


	m_pActRun->setEnabled(true);
    m_pActStop->setEnabled(false);
    m_pActStepOver->setEnabled(false);
    
    // Create Kate part editor
    m_pKateView = createKatePart(pKatePartFactory);
    m_pFrameSourceCodeLayout->addWidget(m_pKateView, 0, 0 );
    
    m_pXmlGuiFactory = pXmlGuiFactory;
	pXmlGuiFactory->addClient(m_pKateView);
		
	// install a working kate part popup dialog thingy
  	if (static_cast<Kate::View*>(m_pKateView->qt_cast("Kate::View")))
  	{
    	static_cast <Kate::View*> (m_pKateView->qt_cast("Kate::View"))->installPopup ((QPopupMenu*)(pXmlGuiFactory->container("ktexteditor_popup", pPoGreView)) );
  	}
    
    m_pKateView->setLineNumbersOn(true);
    m_pKateView->setIconBorder(true);
        
    KTextEditor::HighlightingInterface *pHighlightIface = KTextEditor::highlightingInterface(m_pKateView->getDoc());
        
    for(uint i = 0; i < pHighlightIface->hlModeCount(); i++) 
    {
    	//kdDebug() << "hlmode("<<i<<"): " << pHighlightIface->hlModeName(i) << endl;
        if (pHighlightIface->hlModeName(i).contains("SQL (PostgreSQL)", false))
        {
        	pHighlightIface->setHlMode(i);
        	break;
        }
     }
    
    setEditorText(pFunction->source());
	
	KTextEditor::MarkInterface *pMarkIface = KTextEditor::markInterface(m_pKateView->getDoc());
	
	KIconLoader *loader = KGlobal::iconLoader();
	
	m_pKateView->getDoc()->setPixmap(KTextEditor::MarkInterface::BreakpointActive, loader->loadIcon("breakpoint_enabled", KIcon::Small));
	
	m_pKateView->getDoc()->setPixmap(KTextEditor::MarkInterface::BreakpointReached, loader->loadIcon("breakpoint_enabled", KIcon::Small));
	
	m_pKateView->getDoc()->setPixmap(KTextEditor::MarkInterface::BreakpointDisabled, loader->loadIcon("breakpoint_disabled", KIcon::Small));
				
	pMarkIface->setMark(1, KTextEditor::MarkInterface::Bookmark);
	pMarkIface->setMark(2, KTextEditor::MarkInterface::BreakpointActive);
	pMarkIface->setMark(3, KTextEditor::MarkInterface::BreakpointReached);
	pMarkIface->setMark(4, KTextEditor::MarkInterface::BreakpointDisabled);
	pMarkIface->setMark(5, KTextEditor::MarkInterface::Execution);
	pMarkIface->setMark(6, KTextEditor::MarkInterface::Warning);
	pMarkIface->setMark(7, KTextEditor::MarkInterface::Error);
}

KPGDebugger::~KPGDebugger()
{
	if ( m_pKateView )
    {
        removeFromGuiFactory();

        // remove the view, then the doc
        Kate::Document *pDoc = m_pKateView->getDoc();
        delete m_pKateView;
        delete pDoc;
    }
}


// Add yourself and Kate view to GUI factory
void KPGDebugger::addToGuiFactory()
{
	if(m_pKateView && !m_bIsAddedToGuiFactory)
    {
        m_pXmlGuiFactory->addClient(this);
        m_pXmlGuiFactory->addClient(m_pKateView);
        m_bIsAddedToGuiFactory = true;
    }
}
    
// Remove yourself and Kate view from GUI factory
void KPGDebugger::removeFromGuiFactory()
{
    if(m_pKateView && m_bIsAddedToGuiFactory)
    {
        m_pXmlGuiFactory->removeClient(this);
        m_pXmlGuiFactory->removeClient(m_pKateView);
        m_bIsAddedToGuiFactory = false;
    }
}

// Create Kate part view
Kate::View* KPGDebugger::createKatePart(KParts::Factory* pFactory)
{
    // The library was found, so create the Kate::Document
    KTextEditor::Document *doc = (KTextEditor::Document *) pFactory->createPart(m_pFrameSourceCode, "", this, "", "KTextEditor::Document");

    // The document only represents the document, to view
    // the document's content
    // we have to create a view for the document.
    Kate::View *view = (Kate::View *) doc->createView( m_pFrameSourceCode, 0L );

    // all went well, so return the view
    return view;
}

// Set function source code
void KPGDebugger::setEditorText(const QString &strTest)
{
	KTextEditor::EditInterface *pEditIface = KTextEditor::editInterface(m_pKateView->document());
	pEditIface->setText(strTest);
		
	KTextEditor::UndoInterface *pUndoIface = KTextEditor::undoInterface(m_pKateView->document());
	pUndoIface->clearUndo();
	pUndoIface->clearRedo();
}

// Get function source code
const QString KPGDebugger::editorText() const 
{
	KTextEditor::EditInterface *pEditIface = KTextEditor::editInterface(m_pKateView->document());
    return pEditIface->text();
}

void KPGDebugger::slotExecute()
{
    // TODO debugger
}

void KPGDebugger::slotStop()
{

}

void KPGDebugger::slotStepOver()
{

}
