/***************************************************************************
                          kpgdatabaseproppage  -  description
                             -------------------
    begin                : So led 31 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgdatabaseproppage.h"

#include "../DbObjects/kpgtreeitem.h"

// include files for Qt
#include <qiconset.h>
#include <qtable.h> 

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <ktextedit.h>
#include <kcombobox.h> 
#include <kdebug.h>
#include <kcursor.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>

#include "../kpglinklabel.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgserver.h"
#include "../kpgutil.h"
#include "../kpgsqldialog.h"

KPGDatabasePropPage::KPGDatabasePropPage(QWidget *parent, KPGDatabase *pDatabase)
 : KPGDatabasePropPageBase(parent, "KPGDatabasePropPage")
{
	m_pDatabase = pDatabase;
  
  	//m_pTableProperties->verticalHeader()->setResizeEnabled( false );
	m_pTabWidget->setTabIconSet(tabCasts, QIconSet(*KPGTreeItem::m_pIconCast)); 
	m_pTabWidget->setTabIconSet(tabLanguages, QIconSet(*KPGTreeItem::m_pIconLanguage)); 
	m_pTabWidget->setTabIconSet(tabSchemas, QIconSet(*KPGTreeItem::m_pIconSchema)); 
	m_pTabWidget->setTabIconSet(tabStatistics, QIconSet(QPixmap(SmallIcon("ksysguard.png")))); 
	
	m_pButtonRefreshStatistics->setIconSet(QIconSet(QPixmap(BarIcon("reload.png"))));
	m_pPushButtonRefreshDiskUsage->setIconSet(QIconSet(QPixmap(BarIcon("reload.png"))));
	m_pButtonRefreshLocks->setIconSet(QIconSet(QPixmap(BarIcon("reload.png"))));
	
	m_pTabWidget->setTabIconSet(tabACL, QIconSet(QPixmap(UserIcon("group.png"))));
	m_pTabWidget->setTabIconSet(tabDiskUsage, QIconSet(QPixmap(UserIcon("disk_usage.png"))));
	m_pTabWidget->setTabIconSet(tabLocks, QIconSet(QPixmap(UserIcon("lock.png")))); 

    m_bPageCastsDisplaied = false;
    displayProperties();
}


KPGDatabasePropPage::~KPGDatabasePropPage()
{
}

// Display properties of underlying database object
void KPGDatabasePropPage::displayProperties()
{
    KPGServer *pServer = static_cast <KPGServer *> (m_pDatabase->parent());
    
    bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;
	    
	// Is it 8.0 or newer ?
	if(pServer->versionMajor() > 7)
    {             
       bVersion80_OrNewer = true;
    }     
	    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion81_OrNewer = true;
	}
		
	if(m_pDatabase->connection() == 0)
	{ 
		m_pTableProperties->setNumRows(0);
		m_pTableStatistics->setNumRows(0);
		m_pTabWidget->setEnabled(false);
		return;
	}
	
	//--- Header
		
	int iRow = 0;
  
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pDatabase->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
		
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pDatabase->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Database name"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pDatabase->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the database, usually the user who created it"));
	
	//--- ACL
	setACL(m_pDatabase->acl());
  
	//--- Path / Tablespace
  	if(!bVersion80_OrNewer)
	{
        m_pTableProperties->setText(iRow, 0, i18n("Path"));
        m_pTableProperties->setText(iRow, 1, m_pDatabase->path());
	    m_pTableProperties->setText(iRow++, 2, i18n("If the database is stored at an alternative location then this records the location. It's either an environment variable name \
or an absolute path, depending how it was entered."));
	}
	else
	{
		m_pTableProperties->setText(iRow, 0, i18n("Tablespace"));
		KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Tablespace" );
		pLabel->setValues(m_pDatabase->oidTablespace(), m_pDatabase->tablespace());
		m_pTableProperties->setCellWidget(iRow, 1, pLabel);
		m_pTableProperties->setText(iRow++, 2, i18n("Tablespace name"));
	}
  
	//--- Encoding
	m_pTableProperties->setText(iRow, 0, i18n("Encoding"));
  	m_pTableProperties->setText(iRow, 1, m_pDatabase->encoding());
	m_pTableProperties->setText(iRow++, 2, i18n("Character encoding for this database"));
	
	//--- Can create
	m_pTableProperties->setText(iRow, 0, i18n("Can create"));
    m_pTableProperties->setText(iRow, 1, (m_pDatabase->canCreate()) ? i18n("Yes") : i18n("No"));
	m_pTableProperties->setText(iRow++, 2, i18n("Does current user have access to database ?"));
	
	//--- Default variables
	m_pTableProperties->setText(iRow, 0, i18n("Default variables"));
    m_pTableProperties->setText(iRow, 1, m_pDatabase->defaultVariables());
	m_pTableProperties->setText(iRow++, 2, i18n("Session defaults for run-time configuration variables"));
	
	//--- Allow connection
	m_pTableProperties->setText(iRow, 0, i18n("Allow connection"));
  	m_pTableProperties->setPixmap(iRow, 1, (m_pDatabase->allowConnections()) ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("If false then no one can connect to this database. This is used to protect the template0 database from being altered."));
	
	//--- Is template
	m_pTableProperties->setText(iRow, 0, i18n("Is template"));
  	m_pTableProperties->setPixmap(iRow, 1, (m_pDatabase->isTemplate()) ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("If true then this database can be used in the TEMPLATE clause of CREATE DATABASE to create a new database as a clone of this \
one."));
	
	//--- Pretty size
	m_pTableProperties->setText(iRow, 0, i18n("Rounded size"));
	if(bVersion81_OrNewer)
	 	m_pTableProperties->setText(iRow, 1, m_pDatabase->prettySize());
	else
		m_pTableProperties->setText(iRow, 1, "N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the database"));
	
	//--- Exact size
	m_pTableProperties->setText(iRow, 0, i18n("Exact size"));
	if(bVersion81_OrNewer)
	 	m_pTableProperties->setText(iRow, 1, QString("%L1 B").arg(m_pDatabase->size()));
	else
		m_pTableProperties->setText(iRow, 1, "N/A");
	
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the database"));
		
	//--- Adjust DataTable columns size
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
	
	//---
	displayStatistics();
	// displayCasts(); Lazy
	displayLanguages();
	displaySchemas();
	displayExtendedStatistics();
}    

void KPGDatabasePropPage::displayCasts()
{
    KPGUtil::fillPropertiesTable(m_pDatabase->resultCasts(), m_pTableCasts);
    m_bPageCastsDisplaied = true;
}
	
void KPGDatabasePropPage::displayLanguages()
{
    KPGUtil::fillPropertiesTable(m_pDatabase->resultLanguages(), m_pTableLanguages);
}
	
void KPGDatabasePropPage::displaySchemas()
{
    KPGUtil::fillPropertiesTable(m_pDatabase->resultSchemas(), m_pTableSchemas);
}
	
void KPGDatabasePropPage::displayStatistics()
{
    QString strQuery(m_pDatabase->queryStatistics()); 
    try
    {
        result pqxxResult = m_pDatabase->connection()->runQuery(strQuery);
    
        if(pqxxResult.size() == 1)
        {
            int iRow = 0;
                
            m_pTableStatistics->setText(iRow, 0, i18n("Number of connections"));
            m_pTableStatistics->setText(iRow, 1, pqxxResult[0]["numbackends"].c_str());
            m_pTableStatistics->setText(iRow++, 2, i18n("Number of active connections to the database"));
                
            m_pTableStatistics->setText(iRow, 0, i18n("Transactions committed"));
            m_pTableStatistics->setText(iRow, 1, pqxxResult[0]["xact_commit"].c_str());
            m_pTableStatistics->setText(iRow++, 2, i18n("Total number of committed transactions"));
                
            m_pTableStatistics->setText(iRow, 0, i18n("Transactions rolled back"));
            m_pTableStatistics->setText(iRow, 1, pqxxResult[0]["xact_rollback"].c_str());
            m_pTableStatistics->setText(iRow++, 2, i18n("Total number of rolled back transactions"));
                
            m_pTableStatistics->setText(iRow, 0, i18n("Readed blocks"));
            m_pTableStatistics->setText(iRow, 1, pqxxResult[0]["blks_read"].c_str());
            m_pTableStatistics->setText(iRow++, 2, i18n("Total number of readed blocks"));
                
            m_pTableStatistics->setText(iRow, 0, i18n("Hitted blocks"));
            m_pTableStatistics->setText(iRow, 1, pqxxResult[0]["blks_hit"].c_str());
            m_pTableStatistics->setText(iRow++, 2, i18n("Total number of hitted blocks"));
                
            //--- Adjust DataTable columns size
            for(int nCol = 0; nCol < 3; nCol++)
            {
                m_pTableStatistics->adjustColumn(nCol);
            }
        }
    }
    catch (const std::exception &e)
    {
        setCursor(KCursor::arrowCursor());
		kdError() << k_funcinfo << e.what() << endl;
		KPGSqlDialog dlg(this, strQuery, e.what());
		dlg.exec();
		return;
    } 
    setCursor(KCursor::arrowCursor());
}
	
void KPGDatabasePropPage::slotRefreshStatistics()
{
    setCursor(KCursor::waitCursor());
  	displayExtendedStatistics();
  	setCursor(KCursor::arrowCursor());
}	
	
void KPGDatabasePropPage::displayExtendedStatistics()
{
    m_pTableStatistics2->setNumRows(0);
    int currentItem = m_pComboBoxStatType->currentItem();
    
    QString strQuery(m_pDatabase->queryExtendedStatistics(currentItem));
        
	try
	{
		pqxx::result pqxxResult = m_pDatabase->connection()->runQuery(strQuery);
		
		// fill properties table with result data
		int nTableCols = KPGUtil::fillPropertiesTable(pqxxResult, m_pTableStatistics2, false);
			
		// field names
		QHeader* hHeader = m_pTableStatistics2->horizontalHeader();
		int nResultCol = 0;
		for(int nCol = 0; nCol < nTableCols; nCol++)
		{
            if(pqxxResult.column_type(nResultCol) == 26)
                nResultCol++; // skip OIDs
                
            hHeader->setLabel(nCol, pqxxResult.column_name(nResultCol++)); 
            m_pTableStatistics2->adjustColumn(nCol);
		}
	}
	catch (const std::exception &e)
	{
		setCursor(KCursor::arrowCursor());
		kdError() << k_funcinfo << e.what() << endl;
		KPGSqlDialog dlg(this, strQuery, e.what());
		dlg.exec();
		return;
	}
}

void KPGDatabasePropPage::slotRefreshLocks()
{
    m_pTableDiskUsage->setNumRows(0);
	
    KPGServer *pServer = static_cast <KPGServer *> (m_pDatabase->parent());
    
    // Is it 8.1 or newer ? If not, return
	if(((pServer->versionMajor() < 8) || (pServer->versionMiddle() <= 1)) && ((pServer->versionMajor() == 8))) 
	{
		KMessageBox::sorry(this, i18n("This requires PostgreSQL 8.1 or newer"));
		return;
	}
    
    setCursor(KCursor::waitCursor());
    
    QString strQuery(m_pDatabase->queryLocks()); 
    try
	{
    	pqxx::result pqxxResult = m_pDatabase->connection()->runQuery(strQuery, KPGConnection::eTransNone);
    	    	
    	// fill properties table with result data
		KPGUtil::fillPropertiesTable(pqxxResult, m_pTableLocks, false);
    }
    catch (const std::exception &e)
	{
		setCursor(KCursor::arrowCursor());
		kdError() << k_funcinfo << e.what() << endl;
		KPGSqlDialog dlg(this, strQuery, e.what());
		dlg.exec();
		return;
	} 
    setCursor(KCursor::arrowCursor());
}

void KPGDatabasePropPage::slotRefreshDiskUsage()
{
	m_pTableDiskUsage->setNumRows(0);
	
    KPGServer *pServer = static_cast <KPGServer *> (m_pDatabase->parent());
    
    // Is it 8.1 or newer ? If not, return
	if(((pServer->versionMajor() < 8) || (pServer->versionMiddle() <= 1)) && ((pServer->versionMajor() == 8))) 
	{
		KMessageBox::sorry(this, i18n("This requires PostgreSQL 8.1 or newer"));
		return;
	}
    
    setCursor(KCursor::waitCursor());
    
    QString strQuery(m_pDatabase->queryDiskUsage()); 
    try
	{
    	pqxx::result pqxxResult = m_pDatabase->connection()->runQuery(strQuery);
    	    	
    	// fill properties table with result data
		KPGUtil::fillPropertiesTable(pqxxResult, m_pTableDiskUsage, false);
    }
    catch (const std::exception &e)
	{
		setCursor(KCursor::arrowCursor());
		kdError() << k_funcinfo << e.what() << endl;
		KPGSqlDialog dlg(this, strQuery, e.what());
		dlg.exec();
		return;
	} 
    setCursor(KCursor::arrowCursor());
}
	

void KPGDatabasePropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGDatabasePropPage::slotTableCastsDblClicked(int iRow, int iCol,int,const QPoint&)
{
    QWidget *w = m_pTableCasts->cellWidget(iRow, iCol);
	if (w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGDatabasePropPage::slotTableLanguagesDblClicked(int iRow, int iCol,int,const QPoint&)
{
    QWidget *w = m_pTableLanguages->cellWidget(iRow, iCol);
	if (w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGDatabasePropPage::slotTableSchemasDblClicked(int iRow, int iCol,int,const QPoint&)
{
    QWidget *w = m_pTableSchemas->cellWidget(iRow, iCol);
	if (w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGDatabasePropPage::slotTableStatistics2DblClicked(int iRow, int iCol,int,const QPoint&)
{
    QWidget *w = m_pTableStatistics2->cellWidget(iRow, iCol);
    if (w == 0)
      return;
          
    KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
    pqxx::oid _oid = pLabel->oid();
      
    if(_oid != 0)
    	emit sigSearchObject(_oid);
}

void KPGDatabasePropPage::slotTableLocksDblClicked(int iRow, int iCol,int,const QPoint&)
{
    QWidget *w = m_pTableLocks->cellWidget(iRow, iCol);
	if (w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGDatabasePropPage::slotTableDiskUsageDblClicked(int iRow, int iCol,int,const QPoint&)
{
    QWidget *w = m_pTableDiskUsage->cellWidget(iRow, iCol);
    if (w == 0)
      return;
          
    KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
    pqxx::oid _oid = pLabel->oid();
      
    if(_oid != 0)
    	emit sigSearchObject(_oid);
}

void KPGDatabasePropPage::setACL(const QString &strACL)
{
	m_pListViewACL->clear();
	m_listOfAclItems.clear();
	m_pLineEditACL->setText(strACL);
	
	QString strAclItem; // string for one ACL item, e.g. miriam=arwdRxt/miriam
	for(unsigned int i = 0; i < strACL.length(); i++)
	{
		if(strACL[i] == '{')
		continue;
		
		if((strACL[i] == ',') || (strACL[i] == ','))
		{
			m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
			strAclItem.truncate(0); // clear ACL string
		}
		else
		{
			strAclItem.append(strACL[i]);
		}
	}
	
	if(!strAclItem.isEmpty())
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
	
	// Traverse list of ACL items
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		QListViewItem * pItem = new QListViewItem( m_pListViewACL, 0 );
		(*it).setListViewItem(pItem);
		
		pItem->setText( 0, (*it).grantee() );
		pItem->setText( 1, (*it).grantor() );
		
		pItem->setPixmap(2, UserIcon((*it).canCreate() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(3, UserIcon((*it).canCreateTemp() ? "box_checked.png" : "box_clear.png"));
			
		if((*it).canPassGrantToOther())
		{  
		pItem->setPixmap(4, UserIcon((*it).canGrantCreate() ? "box_checked.png" : "box_clear.png"));
		pItem->setPixmap(5, UserIcon((*it).canGrantCreateTemp() ? "box_checked.png" : "box_clear.png")); 
		}
	} 
}

void KPGDatabasePropPage::slotAclListViewClicked(QListViewItem *pItem, const QPoint &, int iColumn)
{
	// Find KPGAclItem using pItem value
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		if(pItem == (*it).getListViewItem())
		{
		// found ...
		
		switch(iColumn)
		{
			case 0:
			case 1: // do nothing on first 2 columns
				break;
			
			case 2:
				pItem->setPixmap(2, UserIcon((*it).toggleCreate() ? "box_checked.png" : "box_clear.png"));
				break;
		
			case 3:
				pItem->setPixmap(3, UserIcon((*it).toggleCreateTemp() ? "box_checked.png" : "box_clear.png"));
				break;
			
			case 4:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(4, UserIcon((*it).toggleGrantCreate() ? "box_checked.png" : "box_clear.png"));
				
				break;
			
			case 5:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(5, UserIcon((*it).toggleGrantCreateTemp() ? "box_checked.png" : "box_clear.png"));
				
				break;
				
			default:
				kdError() << k_funcinfo << " Unexpected column !" << endl;
				break;      
		}
		
		m_pPushButtonUpdateACL->setEnabled(true);
		return;
		}
	}
}

void KPGDatabasePropPage::slotUpdateACL()
{
	QString strSQL;
	
	// Traverse all items and get their SQL's
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		strSQL.append((*it).getSQL("DATABASE " + KPGUtil::quotedName(m_pDatabase->text(0))));
	}
	
	if(!strSQL.isEmpty())
		emit sigRunWizard(strSQL);
}

// Return Result table for clipboard actions and export. 
QTable* KPGDatabasePropPage::tableResult() 
{ 
	switch(m_pTabWidget->currentPageIndex())
	{
		case 0: return m_pTableProperties; 
				break;
				
		case 1: return 0; 
				break;
				
		case 2: return m_pTableCasts; 
				break;
				
		case 3: return m_pTableLanguages; 
				break;
				
		case 4: return m_pTableSchemas; 
				break;
				
		case 5: return m_pTableStatistics2; 
				break;	
				
		case 6: return m_pTableLocks; 
				break;	
				
	    case 7: return m_pTableDiskUsage; 
				break;	
	}
	
	return 0;
}

// Consumes request for context menu for property table
void KPGDatabasePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

void KPGDatabasePropPage::slotCurrentTabChanged(QWidget *pPropertyPage)
{	
	if((pPropertyPage == tabCasts) && (!m_bPageCastsDisplaied))
	{
	   setCursor(KCursor::waitCursor());
	   displayCasts();
	   setCursor(KCursor::arrowCursor());	
	}
}

#include "kpgdatabaseproppage.moc"
