//
// C++ Interface: kpgdomainproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDOMAINPROPPAGE_H
#define KPGDOMAINPROPPAGE_H

#include "kpgdomainproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx
#include <pqxx/util> 

class KPGDomain;

/**
  * Domain properties
  *
  * @author Lumir Vanek
  */
class KPGDomainPropPage : public KPGDomainPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGDomainPropPage(QWidget *parent, KPGDomain *);
    ~KPGDomainPropPage();

	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
	// Display properties of underlying database object
	virtual void displayProperties();	
	
protected:
	
	KPGDomain *m_pDomain;
	
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
		
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
	
signals:
	void sigSearchObject(const pqxx::oid);
			            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
