//
// C++ Implementation: kpgforeignkeyconstrproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgforeignkeyconstrproppage.h"

#include <qtable.h>  

#include <kdebug.h>
#include <klocale.h>

#include "../kpglinklabel.h"
#include "../kpgutil.h"
#include "../DbObjects/kpgforeignkeyconstr.h"


KPGForeignKeyConstrPropPage::KPGForeignKeyConstrPropPage(QWidget *pParent, KPGForeignKeyConstr *pForeignKeyConstr)
 : KPGForeignKeyConstrPropPageBase(pParent, "KPGForeignKeyConstrPropPage")
{
	m_pForeignKeyConstr = pForeignKeyConstr;
	displayProperties();
}


KPGForeignKeyConstrPropPage::~KPGForeignKeyConstrPropPage()
{
}

void KPGForeignKeyConstrPropPage::displayProperties()
{
	QHeader* hHeader = m_pTableProperties->horizontalHeader();

  	hHeader->setLabel(0, i18n("Name"));
	hHeader->setLabel(1, i18n("Value"));
	hHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pForeignKeyConstr->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pForeignKeyConstr->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Constraint name (not necessarily unique!)"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pForeignKeyConstr->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the constraint"));
	
	//--- Is Deferrable
	m_pTableProperties->setText(iRow, 0, i18n("Is Deferrable"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pForeignKeyConstr->isDeferrable() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Is the constraint deferrable ?"));
	
	//--- Is Deferred
	m_pTableProperties->setText(iRow, 0, i18n("Is Deferred"));
  	m_pTableProperties->setPixmap(iRow, 1, m_pForeignKeyConstr->isDeferred() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("Is the constraint deferred by default ?"));
			
	//--- Update action
	m_pTableProperties->setText(iRow, 0, i18n("Update action"));
  	m_pTableProperties->setText(iRow, 1, m_pForeignKeyConstr->updType());
	m_pTableProperties->setText(iRow++, 2, i18n("Foreign key update action code"));
	
	//--- Delete action
	m_pTableProperties->setText(iRow, 0, i18n("Delete action"));
  	m_pTableProperties->setText(iRow, 1, m_pForeignKeyConstr->delType());
	m_pTableProperties->setText(iRow++, 2, i18n("Foreign key deletion action code"));
		
	//--- Constraint key
	m_pTableProperties->setText(iRow, 0, i18n("Constraint key"));
 	m_pTableProperties->setText(iRow, 1, m_pForeignKeyConstr->constrKey());
	m_pTableProperties->setText(iRow++, 2, i18n("List of columns which the constraint constrains."));
	
	//--- Namespace
	m_pTableProperties->setText(iRow, 0, i18n("Namespace"));
  	m_pTableProperties->setText(iRow, 1, m_pForeignKeyConstr->nspName());
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the namespace"));
	
	//--- Referenced table
	m_pTableProperties->setText(iRow, 0, i18n("Referenced table"));
  	KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Referenced table" );
	pLabel->setValues(m_pForeignKeyConstr->oidReferencedTable(), m_pForeignKeyConstr->referencedTable());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Referenced table name"));
	
	//--- Foreign key
	m_pTableProperties->setText(iRow, 0, i18n("Foreign key"));
  	m_pTableProperties->setText(iRow, 1, m_pForeignKeyConstr->foreignKey());
	m_pTableProperties->setText(iRow++, 2, i18n("This is an array of the referenced columns."));
			
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
}

void KPGForeignKeyConstrPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
		if(w == 0)
			return;
					
		KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
		pqxx::oid _oid = pLabel->oid();
			
		if(_oid != 0)
			emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGForeignKeyConstrPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgforeignkeyconstrproppage.moc"
