//
// C++ Interface: kpgindexproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGINDEXPROPPAGE_H
#define KPGINDEXPROPPAGE_H

#include "kpgindexproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGSyntaxHighlighter;
class KPGIndex;

/**
  * Index properties
  *
  * @author Lumir Vanek
  */
class KPGIndexPropPage : public KPGIndexPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGIndexPropPage(QWidget *parent, KPGIndex *);
    ~KPGIndexPropPage();
	
	// Display properties of underlying database object
	virtual void displayProperties();
	void displayStatistics();
    void displayIoStatistics();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected slots:

    /**
     * Changes syntax highlighting colors.
     */
    void slotSqlEditorSettingsChanged();

	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	virtual void slotRefreshStatistics();
	
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);
    
signals:
	void sigSearchObject(const pqxx::oid);
                
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);

protected:
	/** Syntax highlighter for index definition */
	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
	KPGIndex *m_pIndex;
};

#endif
