//
// C++ Interface: kpg3stepswizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPG3STEPSWIZARD_H
#define KPG3STEPSWIZARD_H

#include "kpg3stepswizardbase.h"

class KPGSyntaxHighlighter;
class KPGConnection;

/**
  * Wizard with 3 steps
  *
  * @author Lumir Vanek
  */
class KPG3StepsWizard : public KPG3StepsWizardBase
{
Q_OBJECT
public:
    KPG3StepsWizard(QWidget *parent = 0, const char *name = 0);
    ~KPG3StepsWizard();

	// Set connection to database
	void setConnection(KPGConnection *);

	// Return connection
    KPGConnection * connection() const { return m_pConnection; }
	
	QWidget * pageWidget1() { return m_pPageWidget1; }
		
protected:
    // Run SQL query - as final Wizard operation
    void runQuery(bool = true);  
    			
protected:
	QWidget *m_pPageWidget1;

private:	
	KPGConnection *m_pConnection;
			
  	/** Syntax highlighter for m_pTextEditSQL */
  	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
						
protected slots:
	// Enable/disable next button for 1st page
	void slotEnableNextButton1(bool);
};

#endif
