//
// C++ Implementation: kpgcreateviewwidget3
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateviewwidget3.h"

// include files for Qt
#include <qpushbutton.h>
#include <qheader.h>

// include files for KDE
#include <kcombobox.h>
#include <klineedit.h>
#include <klistbox.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgschema.h"
#include "../DbObjects/kpgtablesfolder.h"
#include "../DbObjects/kpgtable.h"
#include "../DbObjects/kpgtablecolumnsfolder.h"
#include "../kpgutil.h"


KPGCreateViewWidget3::KPGCreateViewWidget3(QWidget *parent, const char *name, KPGDatabase *pDatabase)
 : KPGCreateViewWidget3Base(parent, name)
{
	m_pDatabase = pDatabase;
  m_bCheckBoxShowSysColumns = false;
	m_eJoinType = joinInner;
	
	m_pListViewJoins->setSortColumn(-1);
}


KPGCreateViewWidget3::~KPGCreateViewWidget3()
{
}

void KPGCreateViewWidget3::slotCheckBoxShowSysColumnsToggled(bool bCheckBoxShowSysColumns)
{
	m_bCheckBoxShowSysColumns = bCheckBoxShowSysColumns;
	refreshAvailColumnsList(m_pComboBoxLeftTables->currentText(), false);
	refreshAvailColumnsList(m_pComboBoxRightTables->currentText(), true);
}

void KPGCreateViewWidget3::refreshAvailColumnsList(const QString & strTableName, bool bRight)
{		
	KListBox *pListBoxColumns;
	if(bRight)
		pListBoxColumns = m_pListBoxRightColumns;
	else	
		pListBoxColumns = m_pListBoxLeftColumns;
			
	pListBoxColumns->clear();
	m_pPushButtonJoinAdd->setEnabled(false);
		
	// Fill list of columns to listbox
	KPGTreeItem *pItem = m_pDatabase->getChildByName(m_strNamespace);
	if(!pItem)
	{
		kdDebug() << k_funcinfo << " No item found: " << m_strNamespace << endl;
		return;
	}
			
	KPGSchema *pSchema = static_cast <KPGSchema *> (pItem);
	KPGTablesFolder *pTablesFolder = pSchema->getTablesFolder();
	
	// Lookup pointer to table
	pItem = pTablesFolder->getChildByName(strTableName);
	if(!pItem)
	{
		kdDebug() << k_funcinfo << " No item found: " << strTableName << endl;
		return;
	}
	
	KPGTable *pTable = static_cast <KPGTable *> (pItem);
	pTable->getTableColumnsFolder()->fillListBoxWithChildItems(pListBoxColumns, m_bCheckBoxShowSysColumns);
}

void KPGCreateViewWidget3::slotComboBoxLeftTableActivated(const QString & strTableName)
{
	refreshAvailColumnsList(strTableName, false);
}

void KPGCreateViewWidget3::slotComboBoxRightTableActivated(const QString & strTableName)
{
	refreshAvailColumnsList(strTableName, true);
}

void KPGCreateViewWidget3::slotViewColumnsLeftSelectChanged(QListBoxItem* pSelectedItem)
{
	m_pPushButtonJoinAdd->setEnabled((pSelectedItem != 0) && (m_pListBoxRightColumns->selectedItem() != 0));
}

void KPGCreateViewWidget3::slotViewColumnsRightSelectChanged(QListBoxItem* pSelectedItem)
{
	m_pPushButtonJoinAdd->setEnabled((pSelectedItem != 0) && (m_pListBoxLeftColumns->selectedItem() != 0));
}

void KPGCreateViewWidget3::slotRadioButtonInnerJoinClicked()
{
	m_eJoinType = joinInner;
}

void KPGCreateViewWidget3::slotRadioButtonLeftJoinClicked()
{
	m_eJoinType = joinLeft;
}

void KPGCreateViewWidget3::slotRadioButtonRigthtJoinClicked()
{
	m_eJoinType = joinRight;
}	
		
void KPGCreateViewWidget3::slotRadioButtonFullJoinClicked()
{
	m_eJoinType = joinFull;
}		

void KPGCreateViewWidget3::slotJoinsSelectionChanged(QListViewItem* pItem)
{
  m_pPushButtonJoinDel->setEnabled(pItem != 0);
}

void KPGCreateViewWidget3::slotJoinsCurrentChanged(QListViewItem* pItem)
{
  m_pPushButtonJoinDel->setEnabled(pItem != 0);
}

void KPGCreateViewWidget3::slotJoinAdd()
{
	QListBoxItem *pLeftSelectedItem = m_pListBoxLeftColumns->selectedItem();
	if(!pLeftSelectedItem) return;

	QListBoxItem *pRightSelectedItem = m_pListBoxRightColumns->selectedItem();
	if(!pRightSelectedItem) return;
	
	// Left table or alias
	QString strLeftTableName(m_pComboBoxLeftTables->currentText());
  	QString strLeftTableAlias = m_MapTableNameAlias[strLeftTableName];
	
	// Right table or alias
	QString strRightTableName(m_pComboBoxRightTables->currentText());
  	QString strRightTableAlias = m_MapTableNameAlias[strRightTableName];
	
	
	// set left column name for view
	QString strLeftColumn;
	
	if(strLeftTableAlias.length() > 0)
	{
		strLeftColumn = strLeftTableAlias;
		strLeftColumn.append(".");
		strLeftColumn.append(KPGUtil::quotedName(pLeftSelectedItem->text()));
	}
	else
	{
		strLeftColumn = KPGUtil::quotedName(strLeftTableName);
		strLeftColumn.append(".");
		strLeftColumn.append(KPGUtil::quotedName(pLeftSelectedItem->text()));
	}
	
	// set right column name for view
	QString strRightColumn;
	
	if(strRightTableAlias.length() > 0)
	{
		strRightColumn = strRightTableAlias;
		strRightColumn.append(".");
		strRightColumn.append(KPGUtil::quotedName(pRightSelectedItem->text()));
	}
	else
	{
		strRightColumn = KPGUtil::quotedName(strRightTableName);
		strRightColumn.append(".");
		strRightColumn.append(KPGUtil::quotedName(pRightSelectedItem->text()));
	}
	
	// Build SQL string
	QString strSQL;
	
	switch(m_eJoinType)
	{
		case joinInner:
			strSQL.append("INNER JOIN ");
			break;
		 
		case  joinLeft:
			strSQL.append("LEFT OUTER JOIN ");
			break; 
			
		case joinRight:
			strSQL.append("RIGHT OUTER JOIN ");
			break; 
			
		case joinFull:
			strSQL.append("FULL OUTER JOIN ");
			break;
	
	}
	
	strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, strRightTableName));
	
	if(strRightTableAlias.length() > 0)
	{
		strSQL.append(" " + strRightTableAlias);
	}
	
	strSQL.append(" ON (");
	strSQL.append(strLeftColumn);
	strSQL.append(" = ");
	strSQL.append(strRightColumn);
	strSQL.append(")");
	
	// Add JOIN to list
	QListViewItem *pLastItem = 0;
	
	QListViewItem * pItem = m_pListViewJoins->firstChild();
	while(pItem)
	{
		pLastItem = pItem;
		pItem = pItem->nextSibling();
	}
	
	QListViewItem *pNewItem;
		
	if(pLastItem == 0) 
		pNewItem = new QListViewItem(m_pListViewJoins, strSQL);
	else
		pNewItem = new QListViewItem(m_pListViewJoins, pLastItem, strSQL);
		
	// Prevent left table from changing
	m_pComboBoxLeftTables->setEnabled(false);
	
}

void KPGCreateViewWidget3::slotJoinDelete()
{
	QListViewItem *pSelectedItem = m_pListViewJoins->selectedItem();
	if(pSelectedItem)
			delete pSelectedItem;
	
	m_pPushButtonJoinDel->setEnabled(false);
	
	m_pComboBoxLeftTables->setEnabled(m_pListViewJoins->childCount() == 0);
}
		
// Return part of SQL statement for CREATE VIEW
const QString KPGCreateViewWidget3::getSQL() const
{
	QString strSQL(" ");
	
	QListViewItem * pItem = m_pListViewJoins->firstChild();
	if(pItem)
	{
		QString strLeftTable(m_pComboBoxLeftTables->currentText());
		QString strLeftTableAlias = m_MapTableNameAlias[strLeftTable];
		strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, strLeftTable));
		if(strLeftTableAlias.length() > 0)
		{
			strSQL.append(" " + strLeftTableAlias);
		}
		
		while(pItem)
		{
			strSQL.append("\n");
			strSQL.append(pItem->text(0));
								
			pItem = pItem->nextSibling();
		}
	}
	else
	{
		for(int i = 0; i < m_pComboBoxLeftTables->count(); i++)
		{
			if(i > 0)
				strSQL.append(", ");
        
			QString strLeftTable(m_pComboBoxLeftTables->text(i));
			QString strLeftTableAlias = m_MapTableNameAlias[strLeftTable];
			strSQL.append(KPGUtil::fullyQualifiedName(m_strNamespace, strLeftTable));
			if(strLeftTableAlias.length() > 0)
			{
				strSQL.append(" " + strLeftTableAlias);
			}
		}
	}
	
	
	return strSQL;
}


#include "kpgcreateviewwidget3.moc"
