//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgmodifyfunctionwizard.h"

// include files for Qt
#include <qlayout.h>
#include <qradiobutton.h>

// include files for KDE
#include <kdebug.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgfunction.h"
#include "kpgcreatefunctionwidget3.h"
#include "kpgcreatefunctionwidget4.h"
#include "../kpgutil.h"


KPGModifyFunctionWizard::KPGModifyFunctionWizard(QWidget *parent, const char *name, const QString &strNamespace, KPGFunction *pFunction)
 : KPG4StepsWizard(parent, name)
{
	m_strNamespace = strNamespace;
	
	// use 2nd and 3rd pages from create function Wizard
	
	KPGCreateFunctionWidget3 *pCreateFunctionWidget3 = new KPGCreateFunctionWidget3(WizardPage1, "KPGCreateFunctionWidget3");
	m_pPageWidget1 = pCreateFunctionWidget3;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateFunctionWidget3, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
	
	KPGCreateFunctionWidget4 *pCreateFunctionWidget4 = new KPGCreateFunctionWidget4(WizardPage2, "KPGCreateFunctionWidget4");
	m_pPageWidget2 = pCreateFunctionWidget4;
	WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
	connect(pCreateFunctionWidget4, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
	
  	languageChange();
	
	m_strFunctionName = pFunction->text(0);
	m_strFunctionArguments = pFunction->argumentTypes();
	m_strReturnTypName = pFunction->returnTypName();
	m_strLanName = pFunction->langName();
	
	// setup 1st page
	if(pFunction->getVolatile() == "s")
		pCreateFunctionWidget3->m_pRadioButtonStable->setChecked(true);
		 
	if(pFunction->getVolatile() == "v")
		pCreateFunctionWidget3->m_pRadioButtonVolatile->setChecked(true);
		
	// NULL arguments behavior
	if(pFunction->isStrict())
		pCreateFunctionWidget3->m_pRadioButtonStrict->setChecked(true);
	
	// Security
	if(pFunction->isSecdef())
		pCreateFunctionWidget3->m_pRadioButtonSecurityDefiner->setChecked(true);	
		
	// Return SET ?
	m_bReturnSet = 	pFunction->returnSet();
		
	// Set function definition
	pCreateFunctionWidget4->m_pTextEditFunctionDefinition->setText(pFunction->source());
	pCreateFunctionWidget4->switchToPage(1);
		
	setNextEnabled(WizardPage1, true);	
	setNextEnabled(WizardPage2, true);	
}

KPGModifyFunctionWizard::~KPGModifyFunctionWizard()
{
}

void KPGModifyFunctionWizard::languageChange()
{
    KPG4StepsWizard::languageChange();
    
    setCaption( i18n( "Modify function" ) );
    
    setTitle( WizardPage1, i18n( "Step 1 - Function properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Function definition" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Review SQL statement" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGModifyFunctionWizard::showPage(QWidget *pPage)
{ 
  if(pPage == WizardPage3) // Step 3 - Review SQL statement
	{
		// prepare SQL statement
		QString strSql("CREATE OR REPLACE FUNCTION ");
		
    	strSql.append(KPGUtil::fullyQualifiedName(m_strNamespace, m_strFunctionName) + m_strFunctionArguments);
    	
    	strSql.append("\nRETURNS ");
		if(m_bReturnSet) strSql.append("SETOF ");
		strSql.append(KPGUtil::quotedName(m_strReturnTypName));
		strSql.append("\nLANGUAGE ");
		strSql.append(KPGUtil::quotedName(m_strLanName));
		strSql.append("\n");
		
		strSql.append((static_cast <KPGCreateFunctionWidget3 *> (m_pPageWidget1))->getSQL());
		strSql.append((static_cast <KPGCreateFunctionWidget4 *> (m_pPageWidget2))->getSQL());
		strSql.append(";");
				
		m_pTextEditSQL->setText(strSql);
	}
	
	if(pPage == WizardPage4) // Step 4 - Check operation result
	{
		runQuery();
	}
	
	// call parent
  	KPG4StepsWizard::showPage(pPage);
}


#include "kpgmodifyfunctionwizard.moc"
