/***************************************************************************
                          kpgobject  -  description
                             -------------------
    begin                : Ne no 1 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGOBJECT_H
#define KPGOBJECT_H

#include "kpgtreeitem.h"

/**
  * Base class for all DB objects, that have OID
  *
  * @author Lumir Vanek
  */
class KPGObject : public KPGTreeItem
{
public:
    KPGObject(KPGTreeItem *, const QString, pqxx::oid);
	KPGObject(KPGTreeItem *, KPGTreeItem *, const QString, pqxx::oid);
    ~KPGObject();
	
	// Return false from KPGTreeItem's, and true for KPGObject's
	virtual bool hasOid() const { return true; }
	
	virtual KPGTreeItem * searchObject(const QString &, pqxx::oid); // search object with given path and OID
    
    virtual bool isSystemObject() const { return false; }
			
	// Get SQL object type (TABLE, VIEW ... )
	virtual const char * getObjectType() const = 0;
	
	/*
	 * Functions for accessing properties
	 */
	 
	 // Return PostgreSQL row identifier
	pqxx::oid oid() const { return m_oid; } 
	const QString & description() const { return m_strDescription; }

protected:

	/*
	 * Properties
	 */
	pqxx::oid m_oid; // PostgreSQL row identifier
	QString m_strDescription;
};

#endif
