/***************************************************************************
                          kpgtableproppage  -  description
                             -------------------
    begin                : So led 31 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kpgtableproppage.h"

// include files for Qt
#include <qiconset.h>
#include <qtable.h>  

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <kcursor.h>
#include <kdebug.h>

#include "../kpglinklabel.h"
#include "../DbObjects/kpgdatabase.h"
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgtable.h"
#include "../DbObjects/kpgschema.h"
#include "../kpgutil.h"
#include "../kpgsqldialog.h"


KPGTablePropPage::KPGTablePropPage(QWidget *parent, KPGTable *pTable)
 : KPGTablePropPageBase(parent, "KPGTablePropPage")
{
  	m_pTable = pTable;
  
	m_pTabWidget->setTabIconSet(tabColumns, QIconSet(*KPGTreeItem::m_pIconColumnOther)); 
	m_pTabWidget->setTabIconSet(tabConstraints, QIconSet(*KPGTreeItem::m_pIconPrimaryKeyConstr)); 
	m_pTabWidget->setTabIconSet(tabIndexes, QIconSet(*KPGTreeItem::m_pIconIndex)); 
	m_pTabWidget->setTabIconSet(tabRules, QIconSet(*KPGTreeItem::m_pIconRule)); m_pTabWidget->setTabIconSet(tabTriggers, QIconSet(*KPGTreeItem::m_pIconTrigger)); 
	m_pTabWidget->setTabIconSet(tabACL, QIconSet(QPixmap(UserIcon("group")))); 
	m_pTabWidget->setTabIconSet(tabStatistics, QIconSet(QPixmap(SmallIcon("ksysguard")))); 
	m_pButtonRefresh->setIconSet(QIconSet(QPixmap(BarIcon("reload")))); 
	
	m_bPageColumnsDisplaied = false;
    m_bPageConstraintsDisplaied = false;
    m_bPageIndexesDisplaied = false;
    m_bPageRulesDisplaied = false;
    m_bPageTriggersDisplaied = false;
    m_bPageStatisticsDisplaied = false;
    
    displayProperties();
}

KPGTablePropPage::~KPGTablePropPage()
{
}

void KPGTablePropPage::displayProperties()
{
	
	// Get pointer to server for version info
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (m_pTable->parent()->parent()->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
	
	bool bVersion80_OrNewer = false;
	bool bVersion81_OrNewer = false;
	    
	// Is it 8.0 or newer ?
	if(pServer->versionMajor() > 7)
    {             
       bVersion80_OrNewer = true;
    }     
	    
    // Is it 8.1 or newer ?
	if(((pServer->versionMajor() == 8) && (pServer->versionMiddle() >= 1)) || ((pServer->versionMajor() > 8))) 
	{
		bVersion81_OrNewer = true;
	}
	
	//--- Header field names
  	QHeader* hHeader = m_pTableProperties->horizontalHeader();

  	hHeader->setLabel(0, i18n("Name"));
	hHeader->setLabel(1, i18n("Value"));
	hHeader->setLabel(2, i18n("Description"));
		
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTable->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pTable->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the table"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pTable->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the table"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pTable->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the table"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Kind"));
	m_pTableProperties->setText(iRow, 1, m_pTable->kind());
	m_pTableProperties->setText(iRow++, 2, i18n("Kind of the table"));
	
	//--- ACL
	setACL(m_pTable->acl());
	
	//--- Has OIDs
	m_pTableProperties->setText(iRow, 0, i18n("Has OIDs"));
  	m_pTableProperties->setPixmap(iRow, 1, (m_pTable->hasOids()) ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("True if we generate an OID for each row of the relation."));
	
	//--- Has subclass
	m_pTableProperties->setText(iRow, 0, i18n("Has subclass"));
  	m_pTableProperties->setPixmap(iRow, 1, (m_pTable->hasSubclass()) ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("At least one table inherits from this one"));
	
	//--- Estimated rows
	m_pTableProperties->setText(iRow, 0, i18n("Estimated rows"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTable->estimatedRows()));
	m_pTableProperties->setText(iRow++, 2, i18n("Number of rows in the table. This is only an estimate used by the planner. It is updated by VACUUM, ANALYZE, and CREATE INDEX. "));
	
	//--- Primary key name
	m_pTableProperties->setText(iRow, 0, i18n("Primary key name"));
  	m_pTableProperties->setText(iRow, 1, m_pTable->primaryKeyName());
	m_pTableProperties->setText(iRow++, 2, i18n("Primary key name"));
	
	//--- Primary key columns
	m_pTableProperties->setText(iRow, 0, i18n("Primary key columns"));
  	m_pTableProperties->setText(iRow, 1, m_pTable->primaryKeyColNumbers());
	m_pTableProperties->setText(iRow++, 2, i18n("Primary key columns numbers"));
	
    //--- Tablespace
	m_pTableProperties->setText(iRow, 0, i18n("Tablespace"));
	KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Tablespace" );
	pLabel->setValues(m_pTable->oidTablespace(), m_pTable->tablespace());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Tablespace name"));
	
	//--- Toast table
	m_pTableProperties->setText(iRow, 0, i18n("Toast table"));
	pLabel = new KPGLinkLabel( m_pTableProperties, "Toast table" );
	pLabel->setValues(m_pTable->oidToastTable(), m_pTable->toastTable());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n(" TOAST table associated with this table. The TOAST table stores large attributes \"out of line\" in a secondary table."));
	
	//--- Pretty size of table
	m_pTableProperties->setText(iRow, 0, i18n("Rounded size"));
	if(bVersion81_OrNewer)
	 	m_pTableProperties->setText(iRow, 1, m_pTable->prettySize());
	else
		m_pTableProperties->setText(iRow, 1, "N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the table"));
	
	//--- Pretty total size
	m_pTableProperties->setText(iRow, 0, i18n("Rounded total size"));
	if(bVersion81_OrNewer)
	 	m_pTableProperties->setText(iRow, 1, m_pTable->prettySizeTotal());
	else
		m_pTableProperties->setText(iRow, 1, "N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the table, including indexes and toasted data"));
	
	//--- Exact size of table
	m_pTableProperties->setText(iRow, 0, i18n("Exact size"));
	if(bVersion81_OrNewer)
	 	m_pTableProperties->setText(iRow, 1, QString("%L1 B").arg(m_pTable->size()));
	else
		m_pTableProperties->setText(iRow, 1, "N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the table"));
	
	//--- Exact total size
	m_pTableProperties->setText(iRow, 0, i18n("Exact total size"));
	if(bVersion81_OrNewer)
	 	m_pTableProperties->setText(iRow, 1, QString("%L1 B").arg(m_pTable->sizeTotal()));
	else
		m_pTableProperties->setText(iRow, 1, "N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the table, including indexes and toasted data"));

		
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
}

void KPGTablePropPage::displayColumns()
{
	QTextCodec * pTextCodec = m_pTable->connection()->textCodec();
		
	KPGUtil::fillPropertiesTable(m_pTable->resultColumns(), m_pTableColumns, pTextCodec);
	m_bPageColumnsDisplaied = true;
}

void KPGTablePropPage::displayConstraints()
{
	QTextCodec * pTextCodec = m_pTable->connection()->textCodec();
		
	KPGUtil::fillPropertiesTable(m_pTable->resultConstraints(), m_pTableConstraints, pTextCodec);
	m_bPageConstraintsDisplaied = true;
}

void KPGTablePropPage::displayIndexes()
{
	KPGDatabase *pDatabase = static_cast <KPGDatabase *> (m_pTable->parent()->parent()->parent());
	KPGServer *pServer = static_cast <KPGServer *> (pDatabase->parent());
	
	// fill properties table with result data
	QTextCodec * pTextCodec = m_pTable->connection()->textCodec();
		
	
	KPGUtil::fillPropertiesTable(m_pTable->resultIndexes(), m_pTableIndexes, pTextCodec, true, (pServer->versionMajor() >= 8) ? 8 : 7);
	m_bPageIndexesDisplaied = true;
}

void KPGTablePropPage::displayRules()
{
	QTextCodec * pTextCodec = m_pTable->connection()->textCodec();
		
	KPGUtil::fillPropertiesTable(m_pTable->resultRules(), m_pTableRules, pTextCodec);
	m_bPageRulesDisplaied = true;
}

void KPGTablePropPage::displayTriggers()
{
	QTextCodec * pTextCodec = m_pTable->connection()->textCodec();
		
	KPGUtil::fillPropertiesTable(m_pTable->resultTriggers(), m_pTableTriggers, pTextCodec);
	m_bPageTriggersDisplaied = false;
}

void KPGTablePropPage::displayStatistics()
{
    try
    {
        pqxx::result pqxxResultStatistics = m_pTable->queryStatistics();
    
        if(pqxxResultStatistics.size() != 1)
        {
        	kdError() << k_funcinfo "Expect one row in result !" <<  endl;
        	return;
        }
        
        if(m_pTable->text(0) != pqxxResultStatistics[0]["relname"].c_str())
        {
        	kdDebug() << k_funcinfo << " table name not match" << endl;
        	return;
        }
        
        int iRow = 0;
        
        //--- seq_scan
        m_pTableStatistics->setText(iRow, 0, i18n("seq_scan"));
        m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["seq_scan"].c_str());
        m_pTableStatistics->setText(iRow++, 2, i18n("Total number of sequential scans"));
        
        //--- seq_scan
        m_pTableStatistics->setText(iRow, 0, i18n("seq_tup_read"));
        m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["seq_tup_read"].c_str());
        m_pTableStatistics->setText(iRow++, 2, i18n("Total number of tuples read"));
        
        //--- idx_scan
        m_pTableStatistics->setText(iRow, 0, i18n("idx_scan"));
        m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_scan"].c_str());
        m_pTableStatistics->setText(iRow++, 2, i18n("Total number of index scans"));
        
        //--- idx_scan
        m_pTableStatistics->setText(iRow, 0, i18n("idx_tup_fetch"));
        m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_tup_fetch"].c_str());
        m_pTableStatistics->setText(iRow++, 2, i18n("Total number of index tuples read"));
        
        //--- n_tup_ins
        m_pTableStatistics->setText(iRow, 0, i18n("n_tup_ins"));
        m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["n_tup_ins"].c_str());
        m_pTableStatistics->setText(iRow++, 2, i18n("Total number of tuples inserted"));
        
        //--- n_tup_upd
        m_pTableStatistics->setText(iRow, 0, i18n("n_tup_upd"));
        m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["n_tup_upd"].c_str());
        m_pTableStatistics->setText(iRow++, 2, i18n("Total number of tuples updated"));
        
        //--- n_tup_del
        m_pTableStatistics->setText(iRow, 0, i18n("n_tup_del"));
        m_pTableStatistics->setText(iRow, 1, pqxxResultStatistics[0]["n_tup_del"].c_str());
        m_pTableStatistics->setText(iRow++, 2, i18n("Total number of tuples deleted"));
        
    	for(int nCol = 0; nCol < 3; nCol++)
		{
			m_pTableStatistics->adjustColumn(nCol);
		}
    }
    catch (const KPGSqlException &e)
	{
        KPGSqlDialog dlg(this, e.sql(), e.message());
	    dlg.exec();
	}
}

void KPGTablePropPage::displayIoStatistics()
{
    try
    {
        pqxx::result pqxxResultStatistics = m_pTable->queryIoStatistics();
    
        if(pqxxResultStatistics.size() != 1) // TODO querying pq_xactloct return no rows... Why ?
        {
            kdError() << k_funcinfo "Expect one row in result !" <<  endl;
            return;
        }
        
        if(m_pTable->text(0) != pqxxResultStatistics[0]["relname"].c_str())
        {
            kdDebug() << k_funcinfo << " table name not match" << endl;
            return;
        }
        
        int iRow = 0;
        
        //--- heap_blks_read
        m_pTableIoStatistics->setText(iRow, 0, i18n("heap_blks_read"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["heap_blks_read"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Total number of disc blocks read"));
        
        //--- heap_blks_hit
        m_pTableIoStatistics->setText(iRow, 0, i18n("heap_blks_hit"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["heap_blks_hit"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Number of buffer hits"));
        
        //--- idx_blks_read
        m_pTableIoStatistics->setText(iRow, 0, i18n("idx_blks_read"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_blks_read"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Total number of disc block read"));
        
        //--- idx_blks_hit
        m_pTableIoStatistics->setText(iRow, 0, i18n("idx_blks_hit"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["idx_blks_hit"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Number of buffer hits in all indexes"));
        
        //--- toast_blks_read
        m_pTableIoStatistics->setText(iRow, 0, i18n("toast_blks_read"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["toast_blks_read"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Number of disc block read from table auxiliary TOAST table"));
        
        //--- n_tup_upd
        m_pTableIoStatistics->setText(iRow, 0, i18n("toast_blks_hit"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["toast_blks_hit"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Number of bufer hits from table auxiliary TOAST table"));
        
        //--- tidx_blks_read
        m_pTableIoStatistics->setText(iRow, 0, i18n("tidx_blks_read"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["tidx_blks_read"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Number of disc block read from table auxiliary TOAST table's index"));
        
        //--- tidx_blks_read
        m_pTableIoStatistics->setText(iRow, 0, i18n("tidx_blks_hit"));
        m_pTableIoStatistics->setText(iRow, 1, pqxxResultStatistics[0]["tidx_blks_hit"].c_str());
        m_pTableIoStatistics->setText(iRow++, 2, i18n("Number of bufer hits from table auxiliary TOAST table's index"));
        
        for(int nCol = 0; nCol < 3; nCol++)
		{
			m_pTableStatistics->adjustColumn(nCol);
		}
    }
    catch (const KPGSqlException &e)
	{
        KPGSqlDialog dlg(this, e.sql(), e.message());
	    dlg.exec();
	}
}

void KPGTablePropPage::slotTablePropDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
    if(w == 0)
      return;
          
    KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
    pqxx::oid _oid = pLabel->oid();
      
    if(_oid != 0)
      emit sigSearchObject(_oid);
}

void KPGTablePropPage::slotTableColumnsDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableColumns->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGTablePropPage::slotTableConstraintsDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableConstraints->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGTablePropPage::slotTableIndexesDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableIndexes->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGTablePropPage::slotTableRulesDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableRules->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGTablePropPage::slotTableTriggersDblClicked(int iRow, int iCol, int, const QPoint&)
{
    QWidget *w = m_pTableTriggers->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

void KPGTablePropPage::slotRefreshStatistics()
{
	displayStatistics();
	displayIoStatistics();
}

void KPGTablePropPage::setACL(const QString &strACL)
{
	m_pListViewACL->clear();
	m_listOfAclItems.clear();
	m_pLineEditACL->setText(strACL);
	
	QString strAclItem; // string for one ACL item, e.g. miriam=arwdRxt/miriam
	for(unsigned int i = 0; i < strACL.length(); i++)
	{
		if(strACL[i] == '{')
		continue;
		
		if((strACL[i] == ',') || (strACL[i] == ','))
		{
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
		strAclItem.truncate(0); // clear ACL string
		}
		else
		{
		strAclItem.append(strACL[i]);
		}
	}
	
	if(!strAclItem.isEmpty())
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
	
	// Traverse list of ACL items
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		QListViewItem * pItem = new QListViewItem( m_pListViewACL, 0 );
		(*it).setListViewItem(pItem);
		
		pItem->setText( 0, (*it).grantee() );
		pItem->setText( 1, (*it).grantor() );
		
		pItem->setPixmap(2, UserIcon((*it).canSelect() ? "box_checked" : "box_clear"));
		pItem->setPixmap(3, UserIcon((*it).canInsert() ? "box_checked" : "box_clear"));
		pItem->setPixmap(4, UserIcon((*it).canUpdate() ? "box_checked" : "box_clear"));
		pItem->setPixmap(5, UserIcon((*it).canDelete() ? "box_checked" : "box_clear"));
		pItem->setPixmap(6, UserIcon((*it).canCreateRule() ? "box_checked" : "box_clear"));
		pItem->setPixmap(7, UserIcon((*it).canCreateReference() ? "box_checked" : "box_clear"));
		pItem->setPixmap(8, UserIcon((*it).canCreateTrigger() ? "box_checked" : "box_clear"));
		
		if((*it).canPassGrantToOther())
		{  
		pItem->setPixmap(9, UserIcon((*it).canGrantSelect() ? "box_checked" : "box_clear"));
		pItem->setPixmap(10, UserIcon((*it).canGrantInsert() ? "box_checked" : "box_clear"));
		pItem->setPixmap(11, UserIcon((*it).canGrantUpdate() ? "box_checked" : "box_clear"));
		pItem->setPixmap(12, UserIcon((*it).canGrantDelete() ? "box_checked" : "box_clear"));
		pItem->setPixmap(13, UserIcon((*it).canGrantCreateRule() ? "box_checked" : "box_clear"));
		pItem->setPixmap(14, UserIcon((*it).canGrantCreateReference() ? "box_checked" : "box_clear"));
		pItem->setPixmap(15, UserIcon((*it).canGrantCreateTrigger() ? "box_checked" : "box_clear")); 
		}
	} 
}

void KPGTablePropPage::slotAclListViewClicked(QListViewItem *pItem, const QPoint &, int iColumn)
{
	// Find KPGAclItem using pItem value
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		if(pItem == (*it).getListViewItem())
		{
		// found ...
		
		switch(iColumn)
		{
			case 0:
			case 1: // do nothing on first 2 columns
				break;
			
			case 2:
				pItem->setPixmap(2, UserIcon((*it).toggleSelect() ? "box_checked" : "box_clear"));
				break;
		
			case 3:
				pItem->setPixmap(3, UserIcon((*it).toggleInsert() ? "box_checked" : "box_clear"));
				break;
				
			case 4:
				pItem->setPixmap(4, UserIcon((*it).toggleUpdate() ? "box_checked" : "box_clear"));
				break;
				
			case 5:
				pItem->setPixmap(5, UserIcon((*it).toggleDelete() ? "box_checked" : "box_clear"));
				break;
				
			case 6:
				pItem->setPixmap(6, UserIcon((*it).toggleCreateRule() ? "box_checked" : "box_clear"));
				break;         
				
			case 7:
				pItem->setPixmap(7, UserIcon((*it).toggleCreateReference() ? "box_checked" : "box_clear"));
				break;
				
			case 8:
				pItem->setPixmap(8, UserIcon((*it).toggleCreateTrigger() ? "box_checked" : "box_clear"));
				break;
						
			case 9:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(9, UserIcon((*it).toggleGrantSelect() ? "box_checked" : "box_clear"));
				
				break;
				
			case 10:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(10, UserIcon((*it).toggleGrantInsert() ? "box_checked" : "box_clear"));
				
				break;
				
			case 11:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(11, UserIcon((*it).toggleGrantUpdate() ? "box_checked" : "box_clear"));
				
				break;
				
			case 12:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(12, UserIcon((*it).toggleGrantDelete() ? "box_checked" : "box_clear"));
				
				break;
				
			case 13:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(13, UserIcon((*it).toggleGrantCreateRule() ? "box_checked" : "box_clear"));
				
				break;         
				
			case 14:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(14, UserIcon((*it).toggleGrantCreateReference() ? "box_checked" : "box_clear"));
				
				break;
				
			case 15:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(15, UserIcon((*it).toggleGrantCreateTrigger() ? "box_checked" : "box_clear"));
				
				break;    
				
			default:
					kdError() << k_funcinfo << " Unexpected column !" << endl;
					break;      
		}
		
		m_pPushButtonUpdateACL->setEnabled(true);
		return;
		}
	}
}

void KPGTablePropPage::slotUpdateACL()
{
	QString strSQL;
	
	KPGSchema *pSchema = static_cast <KPGSchema *> (m_pTable->parent()->parent());
		
	// Traverse all items and get their SQL's
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		strSQL.append((*it).getSQL("TABLE " + KPGUtil::fullyQualifiedName(pSchema->text(0), m_pTable->text(0))));
	}
	
	if(!strSQL.isEmpty())
		emit sigRunWizard(strSQL);
}

// Consumes request for context menu for property table
void KPGTablePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

// Return Result table for clipboard actions and export. 
QTable* KPGTablePropPage::tableResult() 
{ 
	switch(m_pTabWidget->currentPageIndex())
	{
		case 0: return m_pTableProperties; 
				break;
				
		case 1: return 0; 
				break;
				
		case 2: return m_pTableColumns; 
				break;
				
		case 3: return m_pTableConstraints; 
				break;
				
		case 4: return m_pTableIndexes; 
				break;
				
		case 5: return m_pTableRules; 
				break;
								
		case 6: return m_pTableTriggers; 
				break;	
						
		case 7: return 0; 
				break;	
	}
	
	return 0;
}

void KPGTablePropPage::slotCurrentTabChanged(QWidget *pPropertyPage)
{	
	setCursor(KCursor::waitCursor());

	if((pPropertyPage == tabColumns) && (!m_bPageColumnsDisplaied))
	   displayColumns();
	else if((pPropertyPage == tabConstraints) && (!m_bPageConstraintsDisplaied))
	   displayConstraints();
	if((pPropertyPage == tabIndexes) && (!m_bPageIndexesDisplaied))
		displayIndexes();
	if((pPropertyPage == tabRules) && (!m_bPageRulesDisplaied))
	   displayRules();   
	if((pPropertyPage == tabTriggers) && (!m_bPageTriggersDisplaied))
	   displayTriggers();
	if((pPropertyPage == tabStatistics) && (!m_bPageStatisticsDisplaied))
	   slotRefreshStatistics();     
	   
	setCursor(KCursor::arrowCursor());	
}

#include "kpgtableproppage.moc"
