/***************************************************************************
                          kpgtableproppage  -  description
                             -------------------
    begin                : So led 31 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KPGTABLEPROPPAGE_H
#define KPGTABLEPROPPAGE_H

#include "kpgtableproppagebase.h"

// include files for libpgxx 
#include <pqxx/util> 

// application specific includes
#include "kpgabstractpropertypage.h"
#include "../kpgaclitem.h"

class KPGTable;

/**
  * Table properties Page
  *
  * @author Lumir Vanek
  */
class KPGTablePropPage : public KPGTablePropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGTablePropPage(QWidget *parent, KPGTable *);
    ~KPGTablePropPage();
    
    // Return Result table for clipboard actions and export. 
	virtual QTable* tableResult();
	
	// Display properties of underlying database object
    virtual void displayProperties();
    
protected:

    void setACL(const QString &);
    
    void displayColumns();	
	void displayConstraints();
	void displayIndexes();	
	void displayRules();	
	void displayTriggers();
	
	void displayStatistics();
	void displayIoStatistics();

protected:
    KPGTable *m_pTable;
    KPGAclItemList m_listOfAclItems;
    
    bool m_bPageColumnsDisplaied;
    bool m_bPageConstraintsDisplaied;
    bool m_bPageIndexesDisplaied;
    bool m_bPageRulesDisplaied;
    bool m_bPageTriggersDisplaied;
    bool m_bPageStatisticsDisplaied;
		
protected slots:

    virtual void slotTablePropDblClicked(int, int, int, const QPoint &);
    virtual void slotTableColumnsDblClicked(int, int, int, const QPoint &);
    virtual void slotTableConstraintsDblClicked(int, int, int, const QPoint &);
    virtual void slotTableIndexesDblClicked(int, int, int, const QPoint &);
    virtual void slotTableRulesDblClicked(int, int, int, const QPoint &);
    virtual void slotTableTriggersDblClicked(int, int, int, const QPoint &);
                
    virtual void slotCurrentTabChanged(QWidget *); 
                
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
	
    virtual void slotRefreshStatistics();
    virtual void slotAclListViewClicked(QListViewItem *, const QPoint &, int);
    virtual void slotUpdateACL();

signals:
    void sigSearchObject(pqxx::oid);
    
    void sigRunWizard(const QString &);
                
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
