//
// C++ Interface: kpgtypeproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTYPEPROPPAGE_H
#define KPGTYPEPROPPAGE_H

#include "kpgtypeproppagebase.h"

// application specific includes
#include "kpgabstractpropertypage.h"

// include files for libpgxx 
#include <pqxx/util> 

class KPGType;

/**
  * Data type properties
  *
  * @author Lumir Vanek
  */
class KPGTypePropPage : public KPGTypePropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGTypePropPage(QWidget *parent, KPGType *);
    ~KPGTypePropPage();
	
	// Display properties of underlying database object
	void displayProperties();
	void displayAttributes();
	
	// Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
protected:

	KPGType * m_pType;
	
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);	
	            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
		
signals:
    void sigSearchObject(pqxx::oid);
	            
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
