//
// C++ Interface: kpgviewproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGVIEWPROPPAGE_H
#define KPGVIEWPROPPAGE_H

#include "kpgviewproppagebase.h"

// include files for libpgxx 
#include <pqxx/util> 

// application specific includes
#include "kpgabstractpropertypage.h"
#include "../kpgaclitem.h"

class KPGView;

/**
  * Database View properties
  *
  * @author Lumir Vanek
  */
class KPGSyntaxHighlighter;

class KPGViewPropPage : public KPGViewPropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGViewPropPage(QWidget *, KPGView *);
    ~KPGViewPropPage();
    
    // Display properties of underlying database object
	virtual void displayProperties();
    
    // Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	
    void setACL(const QString &);
    
protected:

	// Syntax highlighter for view definition
	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
	
	KPGView * m_pView;
	KPGAclItemList m_listOfAclItems;
          
protected slots:

    // Changes syntax highlighting colors.
    void slotSqlEditorSettingsChanged();

    virtual void slotTablePropDblClicked(int, int, int, const QPoint &);  
	virtual void slotAclListViewClicked(QListViewItem *, const QPoint &, int);
    virtual void slotUpdateACL();
                
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
	
signals:
    void sigSearchObject(pqxx::oid);
    void sigRunWizard(const QString &);
                
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
