//
// C++ Interface: kpgsqledit
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGSQLEDIT_H
#define KPGSQLEDIT_H

// include files for KDE
#include <ktextedit.h>
#include <kcompletion.h>

#include "../DbObjects/kpgtreeitem.h"
#include "../Wizards/kpgtablecolumnwizinfo.h"

// Forward references
class KPGCompletionBox;
class KPGSyntaxHighlighter;
class KFind;
class KReplace;
class QTimer;

/**
  * SQL editor with sytnax highlighting and code completion
  *
  *	@author Lumir Vanek <lvanek@users.sourceforge.net>
  * @todo Use KatePart instead od it 
  */
class KPGSqlEdit : public KTextEdit, public KCompletionBase
{
	Q_OBJECT
public:
	// Enumerates code completion modes
     enum ECompletionMode { modeNone = 0, modeMainObjects, modeSchemaChilds, modeTableColumns };

    KPGSqlEdit(QWidget*, const char*);
    ~KPGSqlEdit();

	// Filters events
	bool eventFilter(QObject *, QEvent *);
		
	virtual void setCompletionObject(KCompletion *, bool = true );
	
	// Set list of main objects for code completition to SQL editor 
	void setListOfObjectsForCodeCompletion(const KPGOidNameList &);
	
	// Set list of schema childs for code completion
    void setListOfSchemaChildsForCodeCompletion(const KPGOidNameList &);
	
	// Clear list of DB objects for code completion
	void clearListOfObjectsForCodeCompletion();
	
	// Clear list of schema childs for code completion
	void clearListOfSchemaChildsForCodeCompletion();
	
	// Set list of table columns for code completion
	void setListOfColumnsForCodeCompletion(const KPGListTableColumns &);
	
	// Clear list of table columns for code completition
	void clearListOfColumnsForCodeCompletion();
	
	// Set cursor position to given character offset
	void highlightCharacter(int);
	
	// Find first occurence of text
    void findFirst(QStringList &);
    
    // Find next occurence of text
	void findNext();
	
	// Replace first occurence of text
	void replace(QStringList &, QStringList &);
	
protected:

	// Return word before cursor position
	const QString uncompletedWord();
	
	// Get uncompleted word, set it to completition and set completed items to box, eventually show it
    void updateCtrlSpaceCompletion(bool);
    
    // Set table columns into completition if table name is left before period: table.
    void updatePeriodCompletion(bool);
	
	// Set completed items to box, eventually show it
	void updateCompletion(bool, const QStringList &);
	
	// Restore completion words from list of main objects
	void restoreCtrlSpaceCompletion();
	
protected:

	// Syntax highlighter
	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
	
	// Current completition mode
	ECompletionMode m_eCompletionMode;
	
	// Completion box for code completion
	KPGCompletionBox *m_pCompletionBox;
	
	// List of main database objects for code completition, from PUBLIC schema
	KPGOidNameAliasesList m_listOfCodeCompletionObjects;
	
	// List of schema childs (tables, views, functions, sequences) for code completition
	KPGOidNameList m_listOfCodeCompletionSchemaChilds;
	
	// List of table/function columns for code completition
	KPGListTableColumns m_listOfCodeCompletionColumns;
	
	// Timer, that ensure periodically update m_listOfCodeCompletionObjects
	QTimer *m_pUpdateCodeCompletionListTimer;
	
	// Flag, indicating, if m_listOfCodeCompletionObjects need to be updated.
	bool m_bCodeCompletionListUpdated;
	
private:
	// A generic implementation of the "find" function
	KFind *m_pFind;

	// A generic implementation of the "replace" function
	KReplace *m_pReplace;
    
    int m_iParaToSearch;

    bool m_bIgnoreSelectionClearing;
	
	int m_iStartPara, m_iStartIdx, m_iEndPara, m_iEndIdx;
	
public slots:

	// KCompletionBase mandatory reimplementation
	virtual void setCompletedText(const QString&);
	
	// KCompletionBase mandatory reimplementation
    virtual void setCompletedItems(const QStringList&);	
	
	// We override this because normally, QTextEdit deselects all the text when
    // the clipboard changes.  This is highly undesirable when there is a modal
    // dialog that the user is working with, which for example searches the
    // selection
    virtual void selectAll(bool);
	
protected slots:
    
	// Changes syntax highlighting colors.
	void slotSqlEditorSettingsChanged();
	
	// Update completition when taxt changed
	void slotTextChanged();
	
	// Highligth found text
    void slotHighlight( const QString &, int, int);
    
    // Find next occurence of text
    void slotFindNext();
    
    // Replace next occurence of text
    void slotReplaceNext();
    
    // Implement updating of replaced text during the replace operation
    void slotReplace(const QString &, int, int, int);
    
    // Fired from m_pUpdateCodeCompletionListTimer
    void slotUpdateCodeCompletionList();
		
signals:
	// Emited, when m_listOfCodeCompletionColumns need update
	void sigRequestTableColumnsListsForCodeCompletion(pqxx::oid);
			
	// Emited, when m_listOfCodeCompletionTableColumns need update
	void sigRequestFunctionReturnTypeAttributesListsForCodeCompletion(const KPGOidNameAliases *);
	
	// Emited, when m_listOfCodeCompletionSchemaChilds need update
	void sigRequestSchemaChildsListsForCodeCompletion(pqxx::oid);
	
protected:
	void setUpFindBoundaries(long, int *, int *, int *, int *);
    
    virtual void virtual_hook( int id, void* data );
};

#endif
