//
// C++ Interface: kpg2stepswizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPG2STEPSWIZARD_H
#define KPG2STEPSWIZARD_H

#include "kpg2stepswizardbase.h"

class KPGSyntaxHighlighter;
class KPGConnection;

/**
  * Wizard with 2 steps. Obviously used for DROP Database object
  *
  * @author Lumir Vanek
  */
class KPG2StepsWizard : public KPG2StepsWizardBase
{
	Q_OBJECT
public:
    KPG2StepsWizard(QWidget *, const QString &, const QString &, bool = true);
    ~KPG2StepsWizard();

	// Set connection to database
	void setConnection(KPGConnection *);

	// Return connection
    KPGConnection * connection() const { return m_pConnection; }
    
protected:
	
	virtual void showPage(QWidget *);
		
private:  
	
    // Connection to database
	KPGConnection *m_pConnection;
		
  	// Syntax highlighter for m_pTextEditSQL
	KPGSyntaxHighlighter *m_pSyntaxHighlighter;
	
	// Noticications list
	QStringList m_listOfNotifications;

	bool m_bWithTransaction;
	
protected slots:
	// Process notice from connection in thread
    void slotProcessNotice(const QString &);
};

#endif
