/***************************************************************************
                          kmyhistorycombo.cpp  -  description
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT includes
#include <qlistbox.h>

// Own includes
#include "kmyhistorycombo.h"

#include <kapplication.h>
#include <kconfig.h>
#include <klocale.h>

#include <qpopupmenu.h>
#include <qtimer.h>

#define TIMER_DELAY 500

#define KRENAME_FILENAME       5000
#define KRENAME_FILENAME_LOWER 5001
#define KRENAME_FILENAME_UPPER 5002
#define KRENAME_NUMBER         5003
#define KRENAME_DATE           5004

KMyHistoryCombo::KMyHistoryCombo( bool customPopup, QWidget* parent, const char* name)
    : KHistoryCombo(parent, name)
{
    QStringList history;
    QStringList completion;
    KConfig* config = kapp->config();
    config->setGroup( name );
    this->setDuplicatesEnabled( false );
    
    history = config->readListEntry("History");
    completion = config->readListEntry("CompletionItems");
    m_timer = new QTimer();
    
    setHistoryItems( history );

    completionObject()->setItems( ( completion.isEmpty() ? history : completion ) );
    setCompletionMode( (KGlobalSettings::Completion)config->readNumEntry( "CompletionMode",
                        KGlobalSettings::completionMode() ) );    
                        
    connect( this, SIGNAL( textChanged( const QString & ) ), this, SLOT( textChangedGovernor() ) );
    connect( m_timer, SIGNAL( timeout() ), this, SIGNAL( delayedTextChanged() ) );

    if( customPopup )
        connect( this, SIGNAL( aboutToShowContextMenu( QPopupMenu* ) ), this, SLOT( slotCustomContextMenu( QPopupMenu* ) ) );
}

KMyHistoryCombo::~KMyHistoryCombo()
{
    delete m_timer;
}

void KMyHistoryCombo::saveSettings()
{
    addToHistory( text() );

    KConfig* config = kapp->config();
    
    config->setGroup( name() ? name() : "KMyHistoryCombo" );
    config->writeEntry( "History", historyItems() );
    config->writeEntry( "CompletionItems", completionObject()->items() );
    config->writeEntry( "CompletionMode", completionMode() );

    config->sync();
}

QString KMyHistoryCombo::text( int index ) const 
{
    return this->listBox()->text( index );
}

void KMyHistoryCombo::setText( const QString & text )
{
    this->lineEdit()->setText( text );
}

void KMyHistoryCombo::add( const QString & text )
{
    int i;
    for ( i = 0; i < this->count(); i++ )
        if( this->text( i ) == text ) {
            QString tmp = this->text( i );
            this->listBox()->removeItem( i );
            this->insertItem( tmp, 0 );
            return;
        }

    if( this->count() == this->maxCount() )
        this->listBox()->removeItem( this->maxCount() );

    this->insertItem( text, 0 );
}

bool KMyHistoryCombo::isEmpty() const
{
    return this->lineEdit()->text().isEmpty();
}

void KMyHistoryCombo::textChangedGovernor()
{
    m_timer->stop();
    m_timer->start( TIMER_DELAY, true );
}

void KMyHistoryCombo::slotCustomContextMenu( QPopupMenu* p )
{
    QPopupMenu* krename = new QPopupMenu( p );
    krename->insertItem( i18n("&Filename"), KRENAME_FILENAME );
    krename->insertItem( i18n("Filename to &lowercase"), KRENAME_FILENAME_LOWER );
    krename->insertItem( i18n("Filename to &uppercase"), KRENAME_FILENAME_UPPER );
    krename->insertItem( i18n("&Number"), KRENAME_NUMBER );
    krename->insertItem( i18n("&Date"), KRENAME_DATE );

    connect( krename, SIGNAL( activated( int ) ), this, SLOT( slotInsertKRenameCommand( int ) ) );

    p->insertSeparator( 0 );
    p->insertItem( i18n("Insert &KRename token"), krename, 0, 0 );
}

void KMyHistoryCombo::slotInsertKRenameCommand( int id )
{
    QString t;

    // TODO:
    // also use constants for KRename tokens!

    switch( id )
    {
        case KRENAME_FILENAME:
            t = "$";
            break;
        case KRENAME_FILENAME_LOWER:
            t = "%";
            break;
        case KRENAME_FILENAME_UPPER:
            t = "&";
            break;
        case KRENAME_NUMBER:
            t = "#";
            break;
        case KRENAME_DATE:
            t = "[date]";
            break;
        default:
            break;
    }

    if( !t.isEmpty() )
        this->lineEdit()->insert( t );
}
