/***************************************************************************
                          myinputdialog.h  -  description
                             -------------------
    begin                : Mit Apr 01 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYINPUTDIALOG_H
#define MYINPUTDIALOG_H

#include <qdialog.h>

class QVBoxLayout;
class QHBoxLayout; 
class QGridLayout; 
class KLineEdit;
class KPushButton;
class QLabel;
class QString;
class MyInputDialog : public QDialog
{ 
    Q_OBJECT
    public:
        MyInputDialog( QString filename, bool revertEnabled = true, QWidget* parent = 0 );
        ~MyInputDialog();

        QString filename();
        void setInputFilename( const QString s ) { m_oldfilename = s; }

        enum returnCodes {
            OK,
            CANCEL,
            USE_KRENAME
        };

    private slots:
        void krename(); // ????? :-)
        void slotFilename();
        void accept();
        void reject();

    private:
        QLabel* TextLabel1;
        KLineEdit* text;
        KPushButton* buttonKrename;
        KPushButton* buttonFilename;
        KPushButton* buttonOk;
        KPushButton* buttonCancel;

        QString m_oldfilename;

    protected:
        QVBoxLayout* MyInputDialogLayout;
        QHBoxLayout* Layout;
};

#endif // MYINPUTDIALOG_H
