/***************************************************************************
                          lmsensorswidget.cpp  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qobject.h>
#include <qobjectlist.h>
#include <qpixmap.h>
#include <qtimer.h>

#include <kiconloader.h>
#include <kstddirs.h>

#include "lmsensorswidget.h"


/***************************************************************************
 *  Public methods                                                         *
 ***************************************************************************/

LMSensorsWidget::LMSensorsWidget(LMSensors *lsensors,QWidget *parent, const char *name )
                                :  QWidget(parent,name,
                                   WStyle_Customize    |
                                   WType_TopLevel      |
                                   WStyle_StaysOnTop   |
                                   WStyle_NormalBorder |
                                   WDestructiveClose     )
{
 sensors= lsensors;
 //
 childDraging = 0;
 //
 timerPanelCount= 0;
 timer = new QTimer(this);
 updateUpdateInterval();
 //
 createInfoPanels();
 //
 setCaption("KSensors");
 setMinimumSize(0,0);
 setSizeIncrement(64,64);
 setBaseSize(64,64);
 //
 setBackgroundPixmap( UserIcon("ksensorsbackground.png") );
 //
 KConfig *cfg= sensors->getConfig();
 cfg->setGroup("ShowWidget");
 QRect rect(32,32,64*4,64*3);
 rect= cfg->readRectEntry ("geometry", &rect);
 move( rect.topLeft() );
 resize( rect.size() );
}


LMSensorsWidget::~LMSensorsWidget()
{
 if(x()>=0 && y()>=0) {
   KConfig *cfg= sensors->getConfig();
   cfg->setGroup("ShowWidget");
   cfg->writeEntry("geometry" , geometry() );
 }
}

// ******************* Public slots ******************************

void LMSensorsWidget::updateItemShow(const char *name)
{
 bool fShow= Panel::readShow(sensors->getConfig(),name);
 Panel *panel= (Panel *)child(name);
 if( fShow!= (bool)panel ) {
    if(panel) {
       delete panel;
    } else {
       LMSensor *sensor= sensors->getSensor(name);
       if(sensor) createSensorPanel(sensor);
       else       createInfoPanel(name);
    }
    adjustSize();
 }
}

void LMSensorsWidget::updateUpdateInterval()
{
 updateInterval= cfgReadUpdateInterval(sensors->getConfig())*1000;
 timer->changeInterval(updateInterval);
}


// ******************* Public static methods **********************

void LMSensorsWidget::cfgWriteUpdateInterval(KConfig *cfg,int interval)
{
 cfg->setGroup("ShowWidget");
 cfg->writeEntry("UpdateInterval" , interval );
}

int LMSensorsWidget::cfgReadUpdateInterval(KConfig *cfg)
{
 cfg->setGroup("ShowWidget");
 return cfg->readNumEntry("UpdateInterval" , 5 );
}


/***************************************************************************
 * Private methods                                                         *
 ***************************************************************************/


// ************* Draging panels and show menu ************************

void LMSensorsWidget::childEventReceived(QEvent *e)
{
QMouseEvent *m = (QMouseEvent*)e;

 switch(e->type()) {
  case QEvent::MouseButtonPress:

      if( m->button()==LeftButton ) startDragChild(m,(QWidget *)sender());
      break;

  case QEvent::MouseButtonRelease:

      if( m->button()==RightButton ) emit rightMouseClicked(m);
      break;
 }
}


void LMSensorsWidget::startDragChild(QMouseEvent *m, QWidget *w)
{
 grabMouse(blankCursor);
 w->raise();
 w->move( m->pos());
 childDraging= w;
}

void LMSensorsWidget::endDragChild()
{
int x= childDraging->x();
int y= childDraging->y();

 if(x<0) x=0;
 if(y<0) y=0;
 releaseMouse();
 childDraging->move(
                     (x+childDraging->width() /2) & (~0x03F) ,
                     (y+childDraging->height()/2) & (~0x03F)
                   );
 saveDisplayConfig((Panel *)childDraging);
 childDraging= 0;
}

void LMSensorsWidget::mouseMoveEvent ( QMouseEvent *m )
{
 if(childDraging) childDraging->move(m->pos());
}


void LMSensorsWidget::mouseReleaseEvent ( QMouseEvent *m )
{
 if(childDraging && m->button()==LeftButton)  endDragChild();
 else
   if(m->button()==RightButton) emit rightMouseClicked(m);
}

// ********** System info panels update stuff ************


void LMSensorsWidget::timerConnect(Panel *display)
{
 if(timerPanelCount==0) timer->start( updateInterval );
 connect( timer  , SIGNAL(timeout()  ), display, SLOT(updateInfo()) );
 connect( display, SIGNAL(destroyed()), this   , SLOT(infoPanelDestroyed()) );
 timerPanelCount++;
}

void LMSensorsWidget::infoPanelDestroyed()
{
 if(--timerPanelCount<=0) timer->stop();
}

// ********************** Panels creation ************************

void LMSensorsWidget::findUnusedPosition(int *px,int *py)
{
bool found;
uint mx,my,x,y,a[32];
QObjectList *list= (QObjectList *)children();

 for(y=0; y<32; y++) a[y]= 0;
 mx= 0; my= 0;
 if(list)
   for(QWidget *obj= (QWidget *)list->first(); obj!=0; obj= (QWidget *)list->next())
     {
       y=obj->y()/64;
       x=obj->x()/64;
       if(x<32 && y<32) a[y]|=  (1 << x);
       if(x>mx) mx= x;
       if(y>my) my= y;
     }
 //
 for(x=0,y=0,found=false;y<=my && !found;) {
   found= ((a[y] & (1 << x))==0);
   if(!found)
     if(++x>mx) { x= 0; y++; }
 }

 if(!found) {
    x= (width()-1) / 64;
    if(x>mx) { x= mx+1; y= 0;    }
    else     { x= 0;    y= my+1; }
 }
 //
 *px= x;
 *py= y;
}

void LMSensorsWidget::loadDisplayConfig(Panel *display)
{
 if(display==0) return;

 bool fNoCfg;
 KConfig *cfg;
 QPoint p(-1,-1);

 cfg= sensors->getConfig();
 cfg->setGroup(display->name());
 p= cfg->readPointEntry("showPos", &p );
 fNoCfg= (p.x()<0 || p.y()<0);
 if(fNoCfg) findUnusedPosition(&p.rx(),&p.ry());
 display->move(p.x()*64,p.y()*64);
 display->show();
 if(fNoCfg) saveDisplayConfig(display);
 display->installEventFilter(this);
 connect(display, SIGNAL(eventReceived(QEvent *)), this, SLOT(childEventReceived(QEvent *)) );
}


void LMSensorsWidget::saveDisplayConfig(Panel *display)
{
KConfig *cfg;

 cfg= sensors->getConfig();
 cfg->setGroup(display->name());
 cfg->writeEntry("show",true);

 QPoint p= display->pos()/64;
 cfg->writeEntry("showPos",p);
}


void LMSensorsWidget::createSensorPanel(LMSensor *sensor)
{
  LMSensorPanel *display= new LMSensorPanel(sensor, this, sensor->name() );
  loadDisplayConfig(display);
}


void LMSensorsWidget::createInfoPanels()
{
 KConfig *cfg=  sensors->getConfig();
 if(Panel::readShow(cfg,"proc.CPUINFO" )) createInfoPanel("proc.CPUINFO");
 if(Panel::readShow(cfg,"proc.RAMINFO" )) createInfoPanel("proc.RAMINFO");
 if(Panel::readShow(cfg,"proc.SWAPINFO")) createInfoPanel("proc.SWAPINFO");
 if(Panel::readShow(cfg,"proc.UPTIME"  )) createInfoPanel("proc.UPTIME");
 if(Panel::readShow(cfg,"proc.CPULOAD" )) createInfoPanel("proc.CPULOAD");
 QObjectList *list= sensors->getSensors();
 if(list) {
   for(LMSensor *sensor= (LMSensor *)list->first(); sensor!=0; sensor= (LMSensor *)list->next()) {
     if( Panel::readShow(cfg,sensor->name()) )
       createSensorPanel( sensor );
   }
 }
 adjustSize();
}

void LMSensorsWidget::createInfoPanel(const char *name)
{
 Panel *panel= 0;
 //
 if(!strcmp(name,"proc.CPUINFO" )) panel= new CpuPanel(this,name);
 else
 if(!strcmp(name,"proc.RAMINFO" )) panel= new RamPanel(this,name);
 else
 if(!strcmp(name,"proc.SWAPINFO")) panel= new SwapPanel(this,name);
 else
 if(!strcmp(name,"proc.CPULOAD" )) panel= new CpuTimePanel(this,name);
 else
 if(!strcmp(name,"proc.UPTIME"  )) panel= new UpTimePanel(this,name);
 //
 loadDisplayConfig(panel);
 timerConnect(panel);
}

// *********************************** End *************************************

