/***************************************************************************
                          lmsensorswidget.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LMSENSORSWIDGET_H
#define LMSENSORSWIDGET_H

#include <qwidget.h>
#include <qpixmap.h>

#include "lmsensors.h"
#include "lmsensorpanel.h"
#include "cpupanel.h"
#include "rampanel.h"
#include "swappanel.h"
#include "cputimepanel.h"
#include "uptimepanel.h"
/**
  *@author 
  */

class LMSensorsWidget : public QWidget  {
   Q_OBJECT
public:

	LMSensorsWidget(LMSensors *lsensors,QWidget *parent=0, const char *name=0);
	~LMSensorsWidget();

  static void cfgWriteUpdateInterval(KConfig *cfg,int seconds);
  static int  cfgReadUpdateInterval(KConfig *cfg);

public slots:

   void updateItemShow(const char *name);
   void updateUpdateInterval();

signals:

   void rightMouseClicked(QMouseEvent *);

private:

  LMSensors *sensors;
  QWidget   *childDraging;
  int        updateInterval;
  int        timerPanelCount;
  QTimer    *timer;

  void loadDisplayConfig(Panel *display);
  void saveDisplayConfig(Panel *display);
  void mouseReleaseEvent ( QMouseEvent *m );
  void mouseMoveEvent ( QMouseEvent *m );

  void createInfoPanels();
  void createSensorPanel(LMSensor *sensor);
  void createInfoPanel(const char *name);
  void findUnusedPosition(int *px,int *py);
  void startDragChild(QMouseEvent *m, QWidget *w);
  void endDragChild();

  void timerConnect(Panel *display);

private slots:

  void childEventReceived(QEvent *);
  void infoPanelDestroyed();
};

#endif
