/***************************************************************************
                          procinfo.c  -  description
                             -------------------
    begin                : Wed Jan 9 2002
    copyright            : (C) 2002 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "procinfo.h"

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

int read_file(const char *name, char *buf, int max)
{
    int fd = open(name, O_RDONLY);
    if(fd >= 0) {
       int r = read(fd, buf, max);
       close(fd);
       return r;
    }
    return -1;
}

int getMemInfo(int *RamTotal,int *RamUsed,int *SwapTotal, int *SwapUsed)
{
char buf[4096];
int mem_free,mem_buffers,mem_cached;
char *p;

    // read memory info
    if(read_file("/proc/meminfo", buf, sizeof(buf)) <= 0) return -1;


    p = strstr(buf, "MemTotal:");
    if(p)  sscanf(p, "MemTotal: %d kB", RamTotal);
    else   *RamTotal= 0;

    p = strstr(buf, "MemFree:");
    if(p) sscanf(p, "MemFree: %d kB", &mem_free);
    else	mem_free= 0;

    p = strstr(buf, "Buffers:");
    if(p) sscanf(p, "Buffers: %d kB", &mem_buffers);
    else  mem_buffers= 0;

    p = strstr(buf, "Cached:");
    if(p) sscanf(p, "Cached: %d kB", &mem_cached);
    else mem_cached= 0;

    p = strstr(buf, "SwapTotal:");
    if(p) sscanf(p, "SwapTotal: %d kB", SwapTotal);
    else  *SwapTotal= 0;

    p = strstr(buf, "SwapFree:");
    if(p) sscanf(p, "SwapFree: %d kB", SwapUsed);
    else  *SwapUsed= 0;

   *SwapUsed= *SwapTotal - *SwapUsed;
   *RamUsed = *RamTotal - mem_free - mem_buffers - mem_cached;

   return 0;
}


bool getCpuTime(int *user,int *nice,int *system,int *idle)
{
char buf[512];

 if(read_file("/proc/stat", buf, sizeof(buf)) <= 0) return false;

 sscanf(buf, "cpu %u %u %u %u",user,nice,system,idle);

 return true;
}


int getUpTime()
{
char buf[256];

 if(read_file("/proc/uptime", buf, sizeof(buf)) < 0) return 0;
 float uptime;
 sscanf(buf, "%f", &uptime);
 return (int)uptime;
}

