/***************************************************************************
                          rampanel.cpp  -  description
                             -------------------
    begin                : Fri Jan 11 2002
    copyright            : (C) 2002 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "swappanel.h"

#include "procinfo.h"

SwapPanel::SwapPanel(QWidget *parent, const char *name): BarMeterPanel(parent,name)
{
  setFooter(QString("SWAP USED"));
  updateInfo();
}

SwapPanel::~SwapPanel(){
}

void SwapPanel::updateInfo()
{
 int memTotal,memUsed,swapTotal,swapUsed;

 getMemInfo(&memTotal,&memUsed,&swapTotal,&swapUsed);

 QString str;
 str.sprintf ("%.0fM" , (double)swapTotal  / 1024 );
 setHeader(str);

 str.sprintf ("%.0fM" , (double)swapUsed  / 1024 );
 setString(str);

 setBarValue(swapUsed,swapTotal);

 update();
}


