#ifndef _KVI_MEMMOVE_H_INCLUDED_
#define _KVI_MEMMOVE_H_INCLUDED_

//
//   File : kvi_memmove.h (/usr/build/NEW_kvirc/kvirc/src/kvicore/kvi_memmove.h)
//   Last major modification : Fri Mar 19 1999 03:15:21 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_settings.h"

#ifndef _KVI_MEMMOVE_CPP_

	extern void *kvi_memmove(void *dst_ptr,const void *src_ptr,int len);
	// In fastmove the src and dst may not overlap

	#ifdef COMPILE_i386_ASM_CODE

	inline void kvi_fastmove(void * dst_ptr,const void *src_ptr,int len)
	{
		__asm__ __volatile__(
			"	cld\n"
			"	shr $1,%0\n"
			"	jnc 1f\n"
			"	movsb\n"
			"1:\n"
			"	shr $1,%0\n"
			"	jnc 2f\n"
			"	movsw\n"
			"2:\n"
			"	repnz; movsl\n"
			: "=c" (len), "=&S" (src_ptr), "=&D" (dst_ptr)
			: "0"  (len), "1"   (src_ptr), "2"   (dst_ptr)
		);
	}

	// Hehe...I am tempted to place a mmx extension here too...but
	// which proggy can assemble that ? My asm SEEMS to not understand movsq ...
	// If your compiler can , and you want to some performance tests , well...use this one.
	// I am not sure that it will work faster in kvirc , because the average
	// size of data moved is probably smaller than 15 bytes ...

	//	inline void kvi_fastmove(void * dst_ptr,const void *src_ptr,int len)
	//	{
	//		__asm__ __volatile__(
	//			"	cld\n"
	//			"	shr $1,%0\n"
	//			"	jnc 1f\n"
	//			"	movsb\n"
	//			"1:\n"
	//			"	shr $1,%0\n"
	//			"	jnc 2f\n"
	//			"	movsw\n"
	//			"2:\n"
	//			"	shr $1,%0\n"
	//			"	jnc 3f\n"
	//			"	movsl\n"
	//			"3:\n"
	//			"	repnz; movsq\n"
	//			: "=c" (len), "=&S" (src_ptr), "=&D" (dst_ptr)
	//			: "0"  (len), "1"   (src_ptr), "2"   (dst_ptr)
	//		);
	//	}

	#else

		extern void kvi_fastmove(void *dst_ptr,const void *src_ptr,int len);

	#endif

#endif
#endif //!_KVI_MEMMOVE_H_INCLUDED_
