//
//   File : kvi_fontdialog.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_fontdialog.cpp)
//   Last major modification : Thu Mar 18 1999 03:52:26 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define _KVI_FONTDIALOG_CPP_

#include "kvi_fontdialog.h"
#include "kvi_settings.h"

#ifndef COMPILE_WITH_KDE

	#include <qfontdialog.h>

	bool kvi_selectFont(QFont &fnt)
	{
		bool bOk = false;
		QFont f = QFontDialog::getFont(&bOk,fnt);
		if(bOk){
			fnt = f;
			return true;
		}
		return false;
	}

#else // COMPILE_WITH_KDE

	#include <kfontdialog.h>

	// KDE Compilation...use standard KDE font dialog
	bool kvi_selectFont(QFont &fnt)
	{
		return (KFontDialog::getFont(fnt) == KFontDialog::Accepted);
	}

#endif

