#ifndef _KVI_IMAGELIB_H_INCLUDED_
#define _KVI_IMAGELIB_H_INCLUDED_

//
//   File : kvi_imagelib.h (/usr/build/KVIrc/kvirc/src/kvilib/kvi_imagelib.h)
//   Last major modification : Wed Jul 21 1999 16:41:14 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

/**
* A class to manage multiple image libraries.<br>
* The library is in fact a big image that contains<br>
* several rows of other smaller images of the same size.<br>
* The images inside the 'library' are indexed in the following way:<br>
* <CODE><br>
* -------------<br>
* |...|...|...|<br>
* |.0.|.1.|.2.|<br>
* -------------<br>
* |...|...|...|<br>
* |.3.|.4.|.5.|<br>
* -------------<br>
* |...|...|...|<br>
* </CODE><br>
* The 'library' image should have the size that is a multiple
* of the single image size. If not , the remaining part is ignored.
* The first image starts always in the left upper corner.
* @short A class to manage multiple image libraries
* @author Szymon Stefanek
* @version 1.0
*/

#include <qpixmap.h>

class KviImageLibrary
{
public:		// Consruction & Destruction
	/**
	* Creates an image library from an user supplied pixmap
	*/
//	KviImageLibrary(const QPixmap &pixmap,int imageWidth,int imageHeight);
	/**
	* Creates an image library from a file on disk.
	* You should at least check if the library was loaded by calling
	* libraryLoaded();. If the library can not be loaded , each call
	* to get image will return a 'white' pixmap with the requested size.
	*/
	KviImageLibrary(const char *path,int imageWidth,int imageHeight);
	/**
	* Same as above but tries the second path if the first one is not ok
	*/
	KviImageLibrary(const char *path1,const char *path2,int imageWidth,int imageHeight);
	/**
	* Destroys the image library
	*/
	~KviImageLibrary();
public:	// Fields
	/**
	* The big image... (this one is 0 if no image has been loaded)
	*/
	QPixmap *m_pLibrary;
	/**
	* Single image width
	*/
	int      m_iWidth;
	/**
	* Single image height
	*/
	int      m_iHeight;
public:	// Methods
	/**
	* Loads a library by path. Returns true if the library can be loaded.<br>
	* If the library can not be loaded , the m_pLibrary field is set to 0.<br>
	* Destroys any previous library loaded.
	*/
	bool loadLibrary(const char *path);
	/**
	* Frees the memory used by the library image.<br>
	* Useful if you want to keep a stable KviImageLibrary object<br>
	* And activate it when needed.
	*/
	void unloadLibrary();
	/**
	* Ensures that the image library has transparent images inside.<br>
	* If the images are not transparent , the transparency is 'created'<br>
	* by the Qt heuristic mask algorithm.
	*/
//	void forceMask();
	/**
	* Returns the number of available images in the library.
	*/
	int imageCount();
	/**
	* Returns true if an image library has been loaded.
	*/
	bool libraryLoaded(){ return (m_pLibrary != 0); };
	QPixmap * getLibrary(){ return m_pLibrary; };
	/**
	* Returns a pixmap image containing the library image at index zeroBasedIndex.<br>
	* If the index is out of range, or there is no library image a blank 32x32 pixmap is generated.
	*/
	QPixmap getImage(int zeroBasedIndex);
	/**
	* Sets the single image width and height.<br>
	*/
	bool setImageSize(int imageWidth,int imageHeight);
};

#endif //_KVI_IMAGELIB_H_INCLUDED_
