#ifndef _KVI_MDI_H_INCLUDED_
#define _KVI_MDI_H_INCLUDED_

//
//   File : kvi_mdi.h (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_mdi.h)
//   Last major modification : Tue Jul 6 1999 16:02:25 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qframe.h>
//#include <qscrollview.h> //tentative

#include <qlist.h>
#include <qpixmap.h>
#include <qpopupmenu.h>

#include "kvi_string.h"
#include "kvi_mdicaption.h" //cross ref

class KviMdiManager;
class KviMdiChild;
class KviMdiCaptionButton;

/**
* A MDI child widget: Usually you don't need to derive from this class.
*/

class KviMdiChild : public QFrame
{
	friend class KviMdiManager;
	friend class KviMdiCaption;
	Q_OBJECT
public:
	enum MdiWindowState { Normal,Maximized,Minimized };
	/**
	* Creates a new KviMdiChild class.<br>
	*/
	KviMdiChild(KviMdiManager *parent,const char * name = 0);
	/**
	* Delicato : destroys this KviMdiChild
	* If a child is still here managed (no recreation was made) it is destroyed too.
	*/
	~KviMdiChild();
public:
	QWidget       *m_pClient;
protected:
	KviMdiManager *m_pManager;
	KviMdiCaption *m_pCaption;
	KviMdiCaptionButton *m_pMinimize;
	KviMdiCaptionButton *m_pMaximize;
	KviMdiCaptionButton *m_pClose;
	MdiWindowState m_state;
	QRect          m_restoredRect;
	int            m_iResizeCorner;
	int            m_iLastCursorCorner;
	bool           m_bResizeMode;
public:
	/**
	* Reparents the widget w to this KviMdiChild (if this is not already done)
	* Installs an event filter to catch focus events.
	* Resizes this mdi child in a way that the child fits perfectly in.
	*/
	void setClient(QWidget *w);
	/**
	* Reparents the client widget to 0 (desktop)
	* Removes the event filter.
	*/
	void unsetClient();
	/**
	* Sets the window icon ponter : assumes 16x16 pixmaps that SHOULD BE NOT DELETED
	* until this object is destroyed.
	*/
	void setIconPointer(QPixmap *ptr);
	/**
	* Enables or disables the close button
	*/
	void enableClose(bool bEnable);
	bool closeEnabled();
	/**
	* Sets the caption of this window
	*/
	void setCaption(const char *text);
	/**
	* Returns the caption of this mdi child.
	* Cool to have it inline...
	*/
	const char * caption(){ return m_pCaption->m_szCaption.ptr(); };
	/**
	* Minimizes , Maximizes or restores the window.
	*/
	void setState(MdiWindowState state,bool bAnimate=true);
	/**
	* Returns the current state of the window
	* Cool to have it inline...
	*/
	inline MdiWindowState state(){ return m_state; };
//	virtual void hide(){ setState(Minimized,false); };
//	virtual void show(){ setState(Normal,false); };
	/**
	* Forces updating the rects of the caption and so...
	* It may be useful when setting the mdiCaptionFont of the MdiManager
	*/
	void updateRects(){ resizeEvent(0); };
private:
	void linkChildren(QWidget *w);
	void unlinkChildren(QWidget *w);
	int getResizeCorner(int ax,int ay);
protected slots:
	void maximizePressed();
	void minimizePressed();
	void closePressed();
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual void leaveEvent(QEvent *);
	virtual bool eventFilter(QObject *o,QEvent *e);
	virtual void focusInEvent(QFocusEvent *);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *);
	void resizeWindow(int resizeCorner);
	void resizeWindowOpaque(int resizeCorner);
	void moveWindow();
	void moveWindowOpaque(QPoint diff);
	void setResizeCursor(int resizeCorner);
	QCursor getResizeCursor(int resizeCorner);
	void calculateResizeRect(int resizeCorner,QPoint mousePos,QRect &resizeRect,int minWidth,int minHeight);
	void calculateMinimumSize(int &minWidth,int &minHeight);
};

/**
* Manager for KviMdiChild widgets.
*/

class KviMdiManager : public QFrame
{
	friend class KviMdiCaption;
	friend class KviMdiChild;
	Q_OBJECT
public:		// Consruction & Destruction
	KviMdiManager(QWidget *parent,const char * name = 0);
	/**
	* Destructor : THERE should be no child windows anymore...
	* Howewer it simply deletes all the child widgets :)
	*/
	~KviMdiManager();
public:		// Fields
	/**
	* Z Order stack (top=last)
	*/
	QList<KviMdiChild> *m_pZ; //Auto delete enabled
private:
	QPopupMenu *m_pWindowMenu;
	QFont m_captionFont;
	QColor m_captionActiveBackColor;
	QColor m_captionActiveForeColor;
	QColor m_captionInactiveBackColor;
	QColor m_captionInactiveForeColor;
	int m_captionFontLineSpacing;
	bool m_bOpaqueMove;
	bool m_bOpaqueResize;
public:		// Methods
	/**
	* Appends a new KviMdiChild to this manager.
	* The child is shown,raised and gets focus if this window has it.
	*/
	void manageChild(KviMdiChild *lpC,bool bShow=true,bool bCascade=true);
	/**
	* Destroys a KviMdiChild managed.<br>
	* Note that if a client is attached to this child , it is deleted too!
	*/
	void destroyChild(KviMdiChild *lpC,bool bFocusTopChild = true);
	/**
	* Brings the child lpC to the top of the stack
	* The children is focused if bSetFocus is true
	* otherwise is raised only
	*/
	void setTopChild(KviMdiChild *lpC,bool bSetFocus=false);
	/**
	* Returns the window menu..the menu is filled by this manager
	* Be sure to not delete it :)
	*/
	inline QPopupMenu *getWindowMenu(){ return m_pWindowMenu; };
	/**
	* Returns the topmost child (the active one) or 0 if there are no children.
	* Note that the topmost child may be also hidded , if ALL the windows are minimized.
	*/
	inline KviMdiChild * topChild(){ return m_pZ->last(); };
	/**
	* Returns the number of visible children
	*/
	int getVisibleChildCount();

	void setMdiCaptionFont(const QFont &fnt);
	void setMdiCaptionActiveForeColor(const QColor &clr);
	void setMdiCaptionActiveBackColor(const QColor &clr);
	void setMdiCaptionInactiveForeColor(const QColor &clr);
	void setMdiCaptionInactiveBackColor(const QColor &clr);
	inline void setOpaqueMove(bool bOpaque){ m_bOpaqueMove = bOpaque; };
	inline void setOpaqueResize(bool bOpaque){ m_bOpaqueResize = bOpaque; };
public slots:
	/**
	* Cascades the windows resizing it to the minimum size.
	*/
	void cascadeWindows();
	/**
	* Casecades the windows resizing it to the maximum available size.
	*/
	void cascadeMaximized();
	void expandVertical();
	void expandHorizontal();
	void expand();
	/**
	* Foces focus to the topmost child
	* In case that it not gets focused automatically...
	* Btw : It should not happen.
	*/
	void focusTopChild();
	/**
	* Forces the update of the window menu.
	*/
	void fillWindowMenu();
	/**
	* Tile Pragma :)
	*/
	void tilePragmaHorizontal();
	void tilePragmaVertical();
	/**
	* Tile Anodine :)
	*/
	void tileAnodine();
	void minimizeTopChild();
	void restoreTopChild();
	void closeTopChild();
protected:	// Protected methods
	void animate(QRect &start,QRect &finish);
	void tileAllInternal(int maxWnds,bool bHorizontal);
//	void drawDragRectangle(QRect &rectToDraw, int style=0);
	virtual void focusInEvent(QFocusEvent *);
	virtual void resizeEvent(QResizeEvent *);
	QPoint getCascadePoint(int indexOfWindow);
	void mousePressEvent(QMouseEvent *e);
	void childMinimized(KviMdiChild *lpC,bool bWasMaximized);
	void childMaximized(KviMdiChild *lpC,bool bWasMinimized);
	void childRestored(KviMdiChild *lpC,bool bWasMaximized);
protected slots:
	void menuActivated(int id);
signals:
	void enterSDIMode(bool bEnter);
};

#endif //_KVI_MDI_H_INCLUDED_
