//
//   File : kvi_asyncwhois.cpp (/usr/build/KVICVS/kvirc/src/kvirc/kvi_asyncwhois.cpp)
//   Last major modification : Tue Sep 21 1999 14:27:16 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_asyncwhois.h"
#include "kvi_frame.h"
#include "kvi_defines.h"
#include "kvi_uparser.h"
#include "kvi_ircsocket.h"

KviAsyncWhois::KviAsyncWhois(KviFrame * pFrm,KviUserParser * pParser)
:QObject()
{
	m_pFrm = pFrm;
	m_pWhoisList = new QList<KviAsyncWhoisEntry>;
	m_pWhoisList->setAutoDelete(true);
	m_pUserParser = pParser;
}

KviAsyncWhois::~KviAsyncWhois()
{
	delete m_pWhoisList; // :)
}

void KviAsyncWhois::clearList()
{
	while(m_pWhoisList->first())m_pWhoisList->removeFirst();
}

KviAsyncWhoisEntry * KviAsyncWhois::findPendingWhois(const char * nick)
{
	for(KviAsyncWhoisEntry * e=m_pWhoisList->first();e;e=m_pWhoisList->next())
	{
		if(kvi_strEqualCI(nick,e->nick.ptr()))return e;
	}
	return 0;
}

bool KviAsyncWhois::start(KviStr &nick,KviStr &server,KviWindow * w,const char *asyncCmd,const char *magic)
{
	if(!nick.hasData())return false;

	KviAsyncWhoisEntry *e = new KviAsyncWhoisEntry;
	e->nick=nick.ptr();
	e->window = w->caption();
	e->bIrcOp=false;

	if(asyncCmd){
		e->asyncCmd = asyncCmd;
		if(magic)e->magic = magic;
	}

	bool bSuccess = false;

	if(server.hasData())bSuccess = m_pUserParser->m_pSocket->sendFmtData("WHOIS %s %s",server.ptr(),nick.ptr());
	else bSuccess = m_pUserParser->m_pSocket->sendFmtData("WHOIS %s",nick.ptr());

	if(bSuccess)m_pWhoisList->append(e);
	else {
		delete (e);
		return false;
	}
	return true;
}

bool KviAsyncWhois::end(KviAsyncWhoisEntry *e,bool bSuccess)
{
	if(!e)return false;

	if(e->asyncCmd.hasData())
		m_pUserParser->asyncWhoisEnd(e->asyncCmd,e->magic,e->window,e->nick,e->user,e->host,e->realName,
			e->server,e->idle,e->status,e->bIrcOp,e->chans,bSuccess);

	m_pWhoisList->removeRef(e);
	return true;
}


#include "m_kvi_asyncwhois.moc"
