#ifndef _KVI_ASYNCWHOIS_H_INCLUDED_
#define _KVI_ASYNCWHOIS_H_INCLUDED_

//
//   File : kvi_asyncwhois.h (/usr/build/KVICVS/kvirc/src/kvirc/kvi_asyncwhois.h)
//   Last major modification : Tue Sep 21 1999 14:25:22 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qobject.h>
#include <qlist.h>

#include "kvi_string.h"
#include "kvi_window.h"

class KviFrame;
class KviUserParser;

typedef struct KviAsyncWhoisEntryTag
{
	KviStr		asyncCmd;
	KviStr		magic;
	KviStr		window;
	KviStr		nick;
	KviStr		user;
	KviStr		host;
	KviStr		realName;
	KviStr		server;
	KviStr		idle;
	KviStr		status;
	KviStr		chans;
	bool		bIrcOp;
} KviAsyncWhoisEntry;


class KviAsyncWhois : public QObject
{
	Q_OBJECT
public:
	KviAsyncWhois(KviFrame * pFrm,KviUserParser * pParser);
	~KviAsyncWhois();
protected:
	KviFrame * m_pFrm;
	QList<KviAsyncWhoisEntry> * m_pWhoisList;
	KviUserParser * m_pUserParser;
public:
	KviAsyncWhoisEntry * findPendingWhois(const char *nick);
	bool start(KviStr &nick,KviStr &server,KviWindow * w,const char *asyncCmd = 0,const char *magic = 0);
	bool end(KviAsyncWhoisEntry *e,bool bSuccess = true);
	void clearList();
};

#endif //!_KVI_ASYNCWHOIS_H_INCLUDED_
